/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.lindorm.client.shaded.com.alibaba.druid.support.http;

import com.aliyun.lindorm.client.shaded.com.alibaba.druid.stat.DruidStatService;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.support.http.ResourceServlet;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.support.logging.Log;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.support.logging.LogFactory;
import com.aliyun.lindorm.client.shaded.javax.servlet.ServletException;
import com.aliyun.lindorm.client.shaded.javax.servlet.http.HttpServletRequest;
import com.aliyun.lindorm.client.shaded.javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.HashMap;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;

public class StatViewServlet
extends ResourceServlet {
    private static final Log LOG = LogFactory.getLog(StatViewServlet.class);
    private static final long serialVersionUID = 1L;
    public static final String PARAM_NAME_RESET_ENABLE = "resetEnable";
    public static final String PARAM_NAME_JMX_URL = "jmxUrl";
    public static final String PARAM_NAME_JMX_USERNAME = "jmxUsername";
    public static final String PARAM_NAME_JMX_PASSWORD = "jmxPassword";
    private DruidStatService statService = DruidStatService.getInstance();
    private String jmxUrl;
    private String jmxUsername;
    private String jmxPassword;
    private MBeanServerConnection conn;

    public StatViewServlet() {
        super("support/http/resources");
    }

    @Override
    public void init() throws ServletException {
        String param;
        super.init();
        try {
            param = this.getInitParameter(PARAM_NAME_RESET_ENABLE);
            if (param != null && param.trim().length() != 0) {
                param = param.trim();
                boolean resetEnable = Boolean.parseBoolean(param);
                this.statService.setResetEnable(resetEnable);
            }
        }
        catch (Exception e) {
            String msg = "initParameter config error, resetEnable : " + this.getInitParameter(PARAM_NAME_RESET_ENABLE);
            LOG.error(msg, e);
        }
        param = this.readInitParam(PARAM_NAME_JMX_URL);
        if (param != null) {
            this.jmxUrl = param;
            this.jmxUsername = this.readInitParam(PARAM_NAME_JMX_USERNAME);
            this.jmxPassword = this.readInitParam(PARAM_NAME_JMX_PASSWORD);
            try {
                this.initJmxConn();
            }
            catch (IOException e) {
                LOG.error("init jmx connection error", e);
            }
        }
    }

    private String readInitParam(String key) {
        String value = null;
        try {
            String param = this.getInitParameter(key);
            if (param != null && (param = param.trim()).length() > 0) {
                value = param;
            }
        }
        catch (Exception e) {
            String msg = "initParameter config [" + key + "] error";
            LOG.warn(msg, e);
        }
        return value;
    }

    private void initJmxConn() throws IOException {
        if (this.jmxUrl != null) {
            JMXServiceURL url = new JMXServiceURL(this.jmxUrl);
            HashMap<String, String[]> env = null;
            if (this.jmxUsername != null) {
                env = new HashMap<String, String[]>();
                String[] credentials = new String[]{this.jmxUsername, this.jmxPassword};
                env.put("jmx.remote.credentials", credentials);
            }
            JMXConnector jmxc = JMXConnectorFactory.connect(url, env);
            this.conn = jmxc.getMBeanServerConnection();
        }
    }

    private String getJmxResult(MBeanServerConnection connetion, String url) throws Exception {
        ObjectName name = new ObjectName("com.aliyun.lindorm.client.shaded.com.alibaba.druid:type=DruidStatService");
        String result = (String)this.conn.invoke(name, "service", new String[]{url}, new String[]{String.class.getName()});
        return result;
    }

    @Override
    protected String process(String url) {
        String resp = null;
        if (this.jmxUrl == null) {
            resp = this.statService.service(url);
        } else if (this.conn == null) {
            try {
                this.initJmxConn();
            }
            catch (IOException e) {
                LOG.error("init jmx connection error", e);
                resp = DruidStatService.returnJSONResult(-1, "init jmx connection error" + e.getMessage());
            }
            if (this.conn != null) {
                try {
                    resp = this.getJmxResult(this.conn, url);
                }
                catch (Exception e) {
                    LOG.error("get jmx data error", e);
                    resp = DruidStatService.returnJSONResult(-1, "get data error:" + e.getMessage());
                }
            }
        } else {
            try {
                resp = this.getJmxResult(this.conn, url);
            }
            catch (Exception e) {
                LOG.error("get jmx data error", e);
                resp = DruidStatService.returnJSONResult(-1, "get data error" + e.getMessage());
            }
        }
        return resp;
    }

    @Override
    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String contextPath = request.getContextPath();
        String servletPath = request.getServletPath();
        String requestURI = request.getRequestURI();
        response.setCharacterEncoding("utf-8");
        if (contextPath == null) {
            contextPath = "";
        }
        String uri = contextPath + servletPath;
        String path = requestURI.substring(contextPath.length() + servletPath.length());
        if ("".equals(path)) {
            if (contextPath.equals("") || contextPath.equals("/")) {
                response.sendRedirect("/druid/index.html");
            } else {
                response.sendRedirect("druid/index.html");
            }
            return;
        }
        if ("/".equals(path)) {
            response.sendRedirect("index.html");
            return;
        }
        super.service(request, response);
    }
}

