/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.lindorm.client.shaded.com.alibaba.druid.support.http;

import com.aliyun.lindorm.client.shaded.com.alibaba.druid.stat.DruidStatService;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.support.http.ResourceServlet;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.support.http.util.IPRange;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.support.logging.Log;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.support.logging.LogFactory;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.util.StringUtils;
import com.aliyun.lindorm.client.shaded.javax.servlet.Filter;
import com.aliyun.lindorm.client.shaded.javax.servlet.FilterChain;
import com.aliyun.lindorm.client.shaded.javax.servlet.FilterConfig;
import com.aliyun.lindorm.client.shaded.javax.servlet.ServletException;
import com.aliyun.lindorm.client.shaded.javax.servlet.ServletRequest;
import com.aliyun.lindorm.client.shaded.javax.servlet.ServletResponse;
import com.aliyun.lindorm.client.shaded.javax.servlet.http.HttpServletRequest;
import com.aliyun.lindorm.client.shaded.javax.servlet.http.HttpServletResponse;
import java.io.IOException;

public class StatViewFilter
implements Filter {
    public static final String PARAM_NAME_PATH = "path";
    private static final Log LOG = LogFactory.getLog(StatViewFilter.class);
    private String servletPath = "/druid";
    private String resourcePath = "support/http/resources";
    private ResourceServlet.ResourceHandler handler;
    private DruidStatService statService = DruidStatService.getInstance();

    public void init(FilterConfig config) throws ServletException {
        String msg;
        IPRange ipRange;
        String[] items;
        String param;
        String paramRemoteAddressHeader;
        String paramPassword;
        if (config == null) {
            return;
        }
        String path = config.getInitParameter(PARAM_NAME_PATH);
        if (path != null && !path.isEmpty()) {
            this.servletPath = path;
        }
        this.handler = new ResourceServlet.ResourceHandler(this.resourcePath);
        String paramUserName = config.getInitParameter("loginUsername");
        if (!StringUtils.isEmpty(paramUserName)) {
            this.handler.username = paramUserName;
        }
        if (!StringUtils.isEmpty(paramPassword = config.getInitParameter("loginPassword"))) {
            this.handler.password = paramPassword;
        }
        if (!StringUtils.isEmpty(paramRemoteAddressHeader = config.getInitParameter("remoteAddress"))) {
            this.handler.remoteAddressHeader = paramRemoteAddressHeader;
        }
        try {
            param = config.getInitParameter("allow");
            if (param != null && param.trim().length() != 0) {
                param = param.trim();
                for (String item : items = param.split(",")) {
                    if (item == null || item.length() == 0) continue;
                    ipRange = new IPRange(item);
                    this.handler.allowList.add(ipRange);
                }
            }
        }
        catch (Exception e) {
            msg = "initParameter config error, allow : " + config.getInitParameter("allow");
            LOG.error(msg, e);
        }
        try {
            param = config.getInitParameter("deny");
            if (param != null && param.trim().length() != 0) {
                param = param.trim();
                for (String item : items = param.split(",")) {
                    if (item == null || item.length() == 0) continue;
                    ipRange = new IPRange(item);
                    this.handler.denyList.add(ipRange);
                }
            }
        }
        catch (Exception e) {
            msg = "initParameter config error, deny : " + config.getInitParameter("deny");
            LOG.error(msg, e);
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpReq = (HttpServletRequest)request;
        HttpServletResponse httpResp = (HttpServletResponse)response;
        String contextPath = ((HttpServletRequest)request).getContextPath();
        String requestURI = httpReq.getRequestURI();
        if (!contextPath.equals("")) {
            requestURI = requestURI.substring(((HttpServletRequest)request).getContextPath().length());
        }
        if (requestURI.equals(this.servletPath)) {
            httpResp.sendRedirect(httpReq.getRequestURI() + '/');
        }
        this.handler.service(httpReq, httpResp, this.servletPath, new ResourceServlet.ProcessCallback(){

            @Override
            public String process(String url) {
                return StatViewFilter.this.statService.service(url);
            }
        });
    }

    public void destroy() {
    }
}

