/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.lindorm.client.shaded.com.alibaba.druid.support.hibernate;

import com.aliyun.lindorm.client.shaded.com.alibaba.druid.pool.DruidDataSource;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.pool.DruidDataSourceFactory;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import org.hibernate.engine.jdbc.connections.spi.ConnectionProvider;
import org.hibernate.service.spi.Configurable;
import org.hibernate.service.spi.Stoppable;

public class DruidConnectionProvider
implements ConnectionProvider,
Configurable,
Stoppable {
    private static final long serialVersionUID = 1026193803901107651L;
    private DruidDataSource dataSource = new DruidDataSource();

    public boolean isUnwrappableAs(Class unwrapType) {
        return this.dataSource.isWrapperFor(unwrapType);
    }

    public <T> T unwrap(Class<T> unwrapType) {
        return this.dataSource.unwrap(unwrapType);
    }

    public Connection getConnection() throws SQLException {
        return this.dataSource.getConnection();
    }

    public void closeConnection(Connection conn) throws SQLException {
        conn.close();
    }

    public boolean supportsAggressiveRelease() {
        return false;
    }

    public void configure(Map configurationValues) {
        try {
            DruidDataSourceFactory.config(this.dataSource, configurationValues);
        }
        catch (SQLException e) {
            throw new IllegalArgumentException("config error", e);
        }
    }

    public void stop() {
        this.dataSource.close();
    }
}

