/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.lindorm.client.shaded.com.alibaba.druid.support.console;

import com.aliyun.lindorm.client.shaded.com.alibaba.druid.support.console.Option;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.support.console.OptionParseException;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.support.console.TabledDataPrinter;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.support.json.JSONUtils;
import com.sun.tools.attach.AgentInitializationException;
import com.sun.tools.attach.AgentLoadException;
import com.sun.tools.attach.AttachNotSupportedException;
import com.sun.tools.attach.VirtualMachine;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;

public class DruidStat {
    private static final String LOCAL_CONNECTOR_ADDRESS_PROP = "com.sun.management.jmxremote.localConnectorAddress";

    public static void main(String[] args) throws Exception {
        Option opt = null;
        if (Option.isPrintHelp(args)) {
            Option.printHelp();
            return;
        }
        try {
            opt = Option.parseOptions(args);
        }
        catch (OptionParseException e) {
            Option.printHelp(e.getMessage());
            return;
        }
        DruidStat.printDruidStat(opt);
    }

    public static void printDruidStat(Option option) throws Exception {
        List content;
        PrintStream out = option.getPrintStream();
        String address = DruidStat.loadManagementAgentAndGetAddress(option.getPid());
        JMXServiceURL jmxUrl = new JMXServiceURL(address);
        JMXConnector jmxc = JMXConnectorFactory.connect(jmxUrl);
        MBeanServerConnection jmxConn = jmxc.getMBeanServerConnection();
        if (option.printDataSourceData()) {
            content = (List)DruidStat.invokeService(jmxConn, 1);
            TabledDataPrinter.printDataSourceData(content, option);
        }
        if (option.printSqlData()) {
            content = (List)DruidStat.invokeService(jmxConn, 2);
            if (content == null) {
                out.println("\u65e0SqlStat\u7edf\u8ba1\u6570\u636e,\u8bf7\u68c0\u67e5\u662f\u5426\u5df2\u6267\u884c\u4e86SQL");
            } else {
                TabledDataPrinter.printSqlData(content, option);
            }
        }
        if (option.printActiveConn()) {
            content = (List)DruidStat.invokeService(jmxConn, 4);
            if (content == null || content.isEmpty()) {
                out.println("\u76ee\u524d\u65e0\u6d3b\u52a8\u4e2d\u7684\u6570\u636e\u5e93\u8fde\u63a5");
            } else {
                TabledDataPrinter.printActiveConnStack(content, option);
            }
        }
    }

    public static List<Integer> getDataSourceIds(Option option) throws Exception {
        String address = DruidStat.loadManagementAgentAndGetAddress(option.getPid());
        JMXServiceURL jmxUrl = new JMXServiceURL(address);
        JMXConnector jmxc = JMXConnectorFactory.connect(jmxUrl);
        MBeanServerConnection jmxConn = jmxc.getMBeanServerConnection();
        List content = (List)DruidStat.invokeService(jmxConn, 1);
        TabledDataPrinter.printDataSourceData(content, option);
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (Map dsStat : content) {
            Integer id = (Integer)dsStat.get("Identity");
            result.add(id);
        }
        return result;
    }

    public static Object invokeService(MBeanServerConnection jmxConn, int dataType) throws Exception {
        String url = Option.getUrl(dataType);
        ObjectName name = new ObjectName("com.aliyun.lindorm.client.shaded.com.alibaba.druid:type=DruidStatService");
        String result = (String)jmxConn.invoke(name, "service", new String[]{url}, new String[]{String.class.getName()});
        Map o = (Map)JSONUtils.parse(result);
        List content = (List)o.get("Content");
        return content;
    }

    private static String loadManagementAgentAndGetAddress(int vmid) throws IOException {
        VirtualMachine vm = null;
        String name = String.valueOf(vmid);
        try {
            vm = VirtualMachine.attach(name);
        }
        catch (AttachNotSupportedException x) {
            throw new IOException(x.getMessage(), x);
        }
        String home = vm.getSystemProperties().getProperty("java.home");
        String agent = home + File.separator + "jre" + File.separator + "lib" + File.separator + "management-agent.jar";
        File f = new File(agent);
        if (!f.exists() && !(f = new File(agent = home + File.separator + "lib" + File.separator + "management-agent.jar")).exists()) {
            throw new IOException("Management agent not found");
        }
        agent = f.getCanonicalPath();
        try {
            vm.loadAgent(agent, "com.sun.management.jmxremote");
        }
        catch (AgentLoadException x) {
            throw new IOException(x.getMessage(), x);
        }
        catch (AgentInitializationException x) {
            throw new IOException(x.getMessage(), x);
        }
        Properties agentProps = vm.getAgentProperties();
        String address = (String)agentProps.get(LOCAL_CONNECTOR_ADDRESS_PROP);
        vm.detach();
        return address;
    }
}

