/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.visitor;

import com.aliyun.lindorm.client.shaded.com.alibaba.druid.DbType;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.ast.SQLExpr;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.ast.SQLObject;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.ast.expr.SQLBetweenExpr;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.ast.expr.SQLBooleanExpr;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.ast.expr.SQLCharExpr;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.ast.expr.SQLDateExpr;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.ast.expr.SQLHexExpr;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.ast.expr.SQLListExpr;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.ast.expr.SQLLiteralExpr;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.ast.expr.SQLNCharExpr;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.ast.expr.SQLNullExpr;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.ast.expr.SQLNumericLiteralExpr;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.ast.expr.SQLTimeExpr;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.ast.expr.SQLTimestampExpr;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.ast.expr.SQLVariantRefExpr;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.dialect.db2.visitor.DB2ExportParameterVisitor;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.dialect.mysql.visitor.MySqlExportParameterVisitor;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.dialect.oracle.visitor.OracleExportParameterVisitor;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.dialect.postgresql.visitor.PGExportParameterVisitor;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.dialect.sqlserver.visitor.MSSQLServerExportParameterVisitor;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.visitor.ExportParameterVisitor;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.visitor.ExportParameterizedOutputVisitor;
import java.util.ArrayList;
import java.util.List;

public final class ExportParameterVisitorUtils {
    private ExportParameterVisitorUtils() {
    }

    public static ExportParameterVisitor createExportParameterVisitor(Appendable out, DbType dbType) {
        if (dbType == null) {
            dbType = DbType.other;
        }
        switch (dbType) {
            case mysql: 
            case mariadb: 
            case tidb: {
                return new MySqlExportParameterVisitor(out);
            }
            case oracle: {
                return new OracleExportParameterVisitor(out);
            }
            case db2: {
                return new DB2ExportParameterVisitor(out);
            }
            case h2: {
                return new MySqlExportParameterVisitor(out);
            }
            case sqlserver: 
            case jtds: {
                return new MSSQLServerExportParameterVisitor(out);
            }
            case postgresql: 
            case edb: {
                return new PGExportParameterVisitor(out);
            }
        }
        return new ExportParameterizedOutputVisitor(out);
    }

    public static boolean exportParamterAndAccept(List<Object> parameters, List<SQLExpr> list) {
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            SQLExpr param = list.get(i);
            SQLExpr result = ExportParameterVisitorUtils.exportParameter(parameters, param);
            if (result == param) continue;
            list.set(i, result);
        }
        return false;
    }

    public static SQLExpr exportParameter(List<Object> parameters, SQLExpr param) {
        ArrayList<Object> value = null;
        boolean replace = false;
        if (param instanceof SQLCharExpr) {
            value = ((SQLCharExpr)param).getText();
            String vStr = value;
            replace = true;
        } else if (param instanceof SQLNCharExpr) {
            value = ((SQLNCharExpr)param).getText();
            replace = true;
        } else if (param instanceof SQLBooleanExpr) {
            value = ((SQLBooleanExpr)param).getBooleanValue();
            replace = true;
        } else if (param instanceof SQLNumericLiteralExpr) {
            value = ((SQLNumericLiteralExpr)param).getNumber();
            replace = true;
        } else if (param instanceof SQLHexExpr) {
            value = (ArrayList<Object>)((SQLHexExpr)param).toBytes();
            replace = true;
        } else if (param instanceof SQLTimestampExpr) {
            value = ((SQLTimestampExpr)param).getValue();
            replace = true;
        } else if (param instanceof SQLDateExpr) {
            value = ((SQLDateExpr)param).getValue();
            replace = true;
        } else if (param instanceof SQLTimeExpr) {
            value = ((SQLTimeExpr)param).getValue();
            replace = true;
        } else if (param instanceof SQLListExpr) {
            SQLListExpr list = (SQLListExpr)param;
            ArrayList<Object> listValues = new ArrayList<Object>();
            for (int i = 0; i < list.getItems().size(); ++i) {
                Object listValue;
                SQLExpr listItem = list.getItems().get(i);
                if (listItem instanceof SQLCharExpr) {
                    listValue = ((SQLCharExpr)listItem).getText();
                    listValues.add(listValue);
                    continue;
                }
                if (listItem instanceof SQLBooleanExpr) {
                    listValue = ((SQLBooleanExpr)listItem).getBooleanValue();
                    listValues.add(listValue);
                    continue;
                }
                if (listItem instanceof SQLNumericLiteralExpr) {
                    listValue = ((SQLNumericLiteralExpr)listItem).getNumber();
                    listValues.add(listValue);
                    continue;
                }
                if (!(listItem instanceof SQLHexExpr)) continue;
                listValue = ((SQLHexExpr)listItem).toBytes();
                listValues.add(listValue);
            }
            if (listValues.size() == list.getItems().size()) {
                value = listValues;
                replace = true;
            }
        } else if (param instanceof SQLNullExpr) {
            value = null;
            replace = true;
        }
        if (replace) {
            SQLObject parent = param.getParent();
            if (parent != null) {
                List<SQLObject> mergedList = null;
                if (parent instanceof SQLBinaryOpExpr) {
                    mergedList = ((SQLBinaryOpExpr)parent).getMergedList();
                }
                if (mergedList != null) {
                    ArrayList<Object> mergedListParams = new ArrayList<Object>(mergedList.size() + 1);
                    for (int i = 0; i < mergedList.size(); ++i) {
                        SQLObject item = mergedList.get(i);
                        if (!(item instanceof SQLBinaryOpExpr)) continue;
                        SQLBinaryOpExpr binaryOpItem = (SQLBinaryOpExpr)item;
                        ExportParameterVisitorUtils.exportParameter(mergedListParams, binaryOpItem.getRight());
                    }
                    if (mergedListParams.size() > 0) {
                        mergedListParams.add(0, value);
                        value = mergedListParams;
                    }
                }
            }
            if (parameters != null) {
                parameters.add(value);
            }
            return new SQLVariantRefExpr("?");
        }
        return param;
    }

    public static void exportParameter(List<Object> parameters, SQLBinaryOpExpr x) {
        SQLExpr rightResult;
        if (x.getLeft() instanceof SQLLiteralExpr && x.getRight() instanceof SQLLiteralExpr && x.getOperator().isRelational()) {
            return;
        }
        SQLExpr leftResult = ExportParameterVisitorUtils.exportParameter(parameters, x.getLeft());
        if (leftResult != x.getLeft()) {
            x.setLeft(leftResult);
        }
        if ((rightResult = ExportParameterVisitorUtils.exportParameter(parameters, x.getRight())) != x.getRight()) {
            x.setRight(rightResult);
        }
    }

    public static void exportParameter(List<Object> parameters, SQLBetweenExpr x) {
        SQLExpr result = ExportParameterVisitorUtils.exportParameter(parameters, x.getBeginExpr());
        if (result != x.getBeginExpr()) {
            x.setBeginExpr(result);
        }
        if ((result = ExportParameterVisitorUtils.exportParameter(parameters, x.getEndExpr())) != x.getBeginExpr()) {
            x.setEndExpr(result);
        }
    }
}

