/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.transform;

import com.aliyun.lindorm.client.shaded.com.alibaba.druid.DbType;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.ast.SQLExpr;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.ast.SQLObject;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.ast.SQLOrderBy;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.ast.expr.SQLAggregateExpr;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.ast.expr.SQLPropertyExpr;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.ast.statement.SQLSelectGroupByClause;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.ast.statement.SQLSelectItem;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.repository.SchemaObject;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.transform.TableMapping;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.visitor.SQLASTVisitorAdapter;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.util.FnvHash;
import java.util.HashMap;
import java.util.Map;

public class SQLRefactorVisitor
extends SQLASTVisitorAdapter {
    private int havingLevel;
    private int groupByLevel;
    private char quote = (char)34;
    private Map<Long, TableMapping> tableMappings = new HashMap<Long, TableMapping>();

    public SQLRefactorVisitor(DbType dbType) {
        this.dbType = dbType;
        switch (dbType) {
            case mysql: 
            case mariadb: 
            case tidb: 
            case ads: {
                this.quote = (char)96;
                break;
            }
        }
    }

    public void addMapping(TableMapping mapping) {
        this.tableMappings.put(mapping.getSrcTableHash(), mapping);
    }

    @Override
    public boolean visit(SQLExprTableSource x) {
        TableMapping mapping = this.findMapping(x);
        if (mapping == null) {
            return true;
        }
        String destTable = mapping.getDestTable();
        x.setExpr(new SQLIdentifierExpr(this.quote(destTable)));
        return false;
    }

    private TableMapping findMapping(SQLExprTableSource x) {
        SchemaObject schemaObject = x.getSchemaObject();
        if (schemaObject == null) {
            return null;
        }
        long nameHashCode = FnvHash.hashCode64(schemaObject.getName());
        return this.tableMappings.get(nameHashCode);
    }

    @Override
    public boolean visit(SQLIdentifierExpr x) {
        SQLObject parent;
        SQLObject ownerObject;
        TableMapping mapping = null;
        if (this.groupByLevel > 0 || this.havingLevel > 0) {
            SQLSelectQueryBlock queryBlock = null;
            for (SQLObject parent2 = x.getParent(); parent2 != null; parent2 = parent2.getParent()) {
                if (!(parent2 instanceof SQLSelectQueryBlock)) continue;
                queryBlock = (SQLSelectQueryBlock)parent2;
                break;
            }
            boolean matchAlias = false;
            if (queryBlock != null) {
                for (SQLSelectItem item : queryBlock.getSelectList()) {
                    if (item.alias_hash() != x.hashCode64()) continue;
                    matchAlias = true;
                    break;
                }
            }
            if (matchAlias) {
                SQLObject parent3 = x.getParent();
                if (parent3 instanceof SQLOrderBy || parent3 instanceof SQLSelectGroupByClause) {
                    return false;
                }
                if (this.havingLevel > 0) {
                    boolean agg = false;
                    while (parent3 != null && !(parent3 instanceof SQLSelectQueryBlock)) {
                        if (parent3 instanceof SQLAggregateExpr) {
                            agg = true;
                            break;
                        }
                        parent3 = parent3.getParent();
                    }
                    if (!agg) {
                        return false;
                    }
                }
            }
        }
        if ((ownerObject = x.getResolvedOwnerObject()) instanceof SQLExprTableSource) {
            mapping = this.findMapping((SQLExprTableSource)ownerObject);
        }
        if (mapping == null) {
            return false;
        }
        String srcName = x.getName();
        String mappingColumn = mapping.getMappingColumn(srcName);
        if (mappingColumn != null) {
            x.setName(this.quote(mappingColumn));
        }
        if ((parent = x.getParent()) instanceof SQLSelectItem && ((SQLSelectItem)parent).getAlias() == null) {
            ((SQLSelectItem)parent).setAlias(srcName);
        }
        return false;
    }

    @Override
    public boolean visit(SQLSelectGroupByClause x) {
        ++this.groupByLevel;
        for (SQLExpr item : x.getItems()) {
            item.accept(this);
        }
        SQLExpr having = x.getHaving();
        if (having != null) {
            ++this.havingLevel;
            having.accept(this);
            --this.havingLevel;
        }
        --this.groupByLevel;
        return false;
    }

    @Override
    public boolean visit(SQLPropertyExpr x) {
        SQLObject parent;
        TableMapping mapping = null;
        SchemaObject schemaObject = null;
        boolean aliasOwer = false;
        SQLObject ownerObject = x.getResolvedOwnerObject();
        if (ownerObject instanceof SQLExprTableSource) {
            SQLExprTableSource exprTableSource = (SQLExprTableSource)ownerObject;
            if (exprTableSource.getAlias() != null && x.getOwner() instanceof SQLIdentifierExpr && FnvHash.hashCode64(exprTableSource.getAlias()) == ((SQLIdentifierExpr)x.getOwner()).nameHashCode64()) {
                aliasOwer = true;
            }
            mapping = this.findMapping(exprTableSource);
            schemaObject = exprTableSource.getSchemaObject();
        }
        if (mapping == null) {
            return false;
        }
        String srcName = x.getName();
        String mappingColumn = mapping.getMappingColumn(srcName);
        if (mappingColumn != null) {
            x.setName(this.quote(mappingColumn));
        }
        if ((parent = x.getParent()) instanceof SQLSelectItem && ((SQLSelectItem)parent).getAlias() == null) {
            ((SQLSelectItem)parent).setAlias(srcName);
        }
        if (x.getOwner() instanceof SQLIdentifierExpr && ((SQLIdentifierExpr)x.getOwner()).nameHashCode64() == mapping.getSrcTableHash() && !aliasOwer) {
            x.setOwner(new SQLIdentifierExpr(this.quote(mapping.getDestTable())));
        }
        return false;
    }

    private String quote(String name) {
        char[] chars = new char[name.length() + 2];
        name.getChars(0, name.length(), chars, 1);
        chars[0] = 96;
        chars[chars.length - 1] = 96;
        return new String(chars);
    }
}

