/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.dialect.sqlserver.visitor;

import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.ast.SQLOrderBy;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.ast.expr.SQLBetweenExpr;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.ast.expr.SQLInListExpr;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.ast.expr.SQLMethodInvokeExpr;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.ast.statement.SQLSelectGroupByClause;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.ast.statement.SQLSelectItem;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.dialect.sqlserver.visitor.SQLServerOutputVisitor;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.visitor.ExportParameterVisitor;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.visitor.ExportParameterVisitorUtils;
import java.util.ArrayList;
import java.util.List;

public class MSSQLServerExportParameterVisitor
extends SQLServerOutputVisitor
implements ExportParameterVisitor {
    private final boolean requireParameterizedOutput;

    public MSSQLServerExportParameterVisitor(List<Object> parameters, Appendable appender, boolean wantParameterizedOutput) {
        super(appender, true);
        this.parameters = parameters;
        this.requireParameterizedOutput = wantParameterizedOutput;
    }

    public MSSQLServerExportParameterVisitor() {
        this(new ArrayList<Object>());
    }

    public MSSQLServerExportParameterVisitor(List<Object> parameters) {
        this(parameters, new StringBuilder(), false);
    }

    public MSSQLServerExportParameterVisitor(Appendable appender) {
        this(new ArrayList<Object>(), appender, true);
    }

    @Override
    public List<Object> getParameters() {
        return this.parameters;
    }

    @Override
    public boolean visit(SQLSelectItem x) {
        if (this.requireParameterizedOutput) {
            return super.visit(x);
        }
        return false;
    }

    @Override
    public boolean visit(SQLOrderBy x) {
        if (this.requireParameterizedOutput) {
            return super.visit(x);
        }
        return false;
    }

    @Override
    public boolean visit(SQLSelectGroupByClause x) {
        if (this.requireParameterizedOutput) {
            return super.visit(x);
        }
        return false;
    }

    @Override
    public boolean visit(SQLMethodInvokeExpr x) {
        if (this.requireParameterizedOutput) {
            return super.visit(x);
        }
        ExportParameterVisitorUtils.exportParamterAndAccept(this.parameters, x.getArguments());
        return true;
    }

    @Override
    public boolean visit(SQLInListExpr x) {
        if (this.requireParameterizedOutput) {
            return super.visit(x);
        }
        ExportParameterVisitorUtils.exportParamterAndAccept(this.parameters, x.getTargetList());
        return true;
    }

    @Override
    public boolean visit(SQLBetweenExpr x) {
        if (this.requireParameterizedOutput) {
            return super.visit(x);
        }
        ExportParameterVisitorUtils.exportParameter((List<Object>)this.parameters, x);
        return true;
    }
}

