/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.dialect.odps.parser;

import com.aliyun.lindorm.client.shaded.com.alibaba.druid.DbType;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.ast.SQLDataType;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.ast.SQLExpr;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.ast.SQLExprImpl;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.ast.SQLName;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.ast.expr.SQLArrayExpr;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.ast.expr.SQLBinaryOperator;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.ast.expr.SQLCharExpr;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.ast.expr.SQLDateExpr;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.ast.expr.SQLDateTimeExpr;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.ast.expr.SQLMethodInvokeExpr;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.ast.expr.SQLPropertyExpr;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.ast.expr.SQLTimestampExpr;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.ast.statement.SQLColumnDefinition;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.ast.statement.SQLExternalRecordFormat;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.ast.statement.SQLSelectItem;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.dialect.odps.ast.OdpsNewExpr;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.dialect.odps.ast.OdpsTransformExpr;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.dialect.odps.ast.OdpsUDTFSQLSelectItem;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.dialect.odps.parser.OdpsLexer;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.dialect.odps.parser.OdpsSelectParser;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.parser.Lexer;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.parser.SQLExprParser;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.parser.SQLParserFeature;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.parser.Token;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.util.FnvHash;
import java.util.Arrays;
import java.util.List;

public class OdpsExprParser
extends SQLExprParser {
    public static final String[] AGGREGATE_FUNCTIONS;
    public static final long[] AGGREGATE_FUNCTIONS_CODES;
    static final long GSONBUILDER;

    public OdpsExprParser(Lexer lexer) {
        super(lexer, DbType.odps);
        this.aggregateFunctions = AGGREGATE_FUNCTIONS;
        this.aggregateFunctionHashCodes = AGGREGATE_FUNCTIONS_CODES;
    }

    public OdpsExprParser(String sql, SQLParserFeature ... features) {
        this(new OdpsLexer(sql, features));
        this.lexer.nextToken();
    }

    public OdpsExprParser(String sql, boolean skipComments, boolean keepComments) {
        this(new OdpsLexer(sql, skipComments, keepComments));
        this.lexer.nextToken();
    }

    @Override
    protected SQLExpr parseAliasExpr(String alias) {
        String chars = alias.substring(1, alias.length() - 1);
        return new SQLCharExpr(chars);
    }

    @Override
    public SQLSelectItem parseSelectItem() {
        SQLExpr expr;
        if (this.lexer.token() == Token.IDENTIFIER) {
            SQLExprImpl ts;
            String literal;
            String stringVal = this.lexer.stringVal();
            long hash_lower = this.lexer.hashLCase();
            this.lexer.nextTokenComma();
            if (FnvHash.Constants.DATETIME == hash_lower && this.lexer.stringVal().charAt(0) != '`' && (this.lexer.token() == Token.LITERAL_CHARS || this.lexer.token() == Token.LITERAL_ALIAS)) {
                literal = this.lexer.stringVal();
                this.lexer.nextToken();
                ts = new SQLDateTimeExpr(literal);
                expr = ts;
            } else if (FnvHash.Constants.DATE == hash_lower && this.lexer.stringVal().charAt(0) != '`' && (this.lexer.token() == Token.LITERAL_CHARS || this.lexer.token() == Token.LITERAL_ALIAS)) {
                literal = this.lexer.stringVal();
                this.lexer.nextToken();
                SQLDateExpr d = new SQLDateExpr(literal);
                expr = d;
            } else if (FnvHash.Constants.TIMESTAMP == hash_lower && this.lexer.stringVal().charAt(0) != '`' && (this.lexer.token() == Token.LITERAL_CHARS || this.lexer.token() == Token.LITERAL_ALIAS)) {
                literal = this.lexer.stringVal();
                this.lexer.nextToken();
                ts = new SQLTimestampExpr(literal);
                expr = ts;
            } else {
                expr = new SQLIdentifierExpr(stringVal);
                if (this.lexer.token() != Token.COMMA) {
                    expr = this.primaryRest(expr);
                    expr = this.exprRest(expr);
                }
            }
        } else {
            expr = this.expr();
        }
        String alias = null;
        if (this.lexer.token() == Token.AS) {
            this.lexer.nextToken();
            if (this.lexer.token() == Token.LPAREN) {
                this.lexer.nextToken();
                OdpsUDTFSQLSelectItem selectItem = new OdpsUDTFSQLSelectItem();
                selectItem.setExpr(expr);
                while (true) {
                    alias = this.lexer.stringVal();
                    this.lexer.nextToken();
                    selectItem.getAliasList().add(alias);
                    if (this.lexer.token() != Token.COMMA) break;
                    this.lexer.nextToken();
                }
                this.accept(Token.RPAREN);
                return selectItem;
            }
            alias = this.alias();
        } else {
            alias = this.as();
        }
        SQLSelectItem item = new SQLSelectItem(expr, alias);
        if (this.lexer.hasComment() && this.lexer.isKeepComments()) {
            item.addAfterComment(this.lexer.readAndResetComments());
        }
        return item;
    }

    @Override
    public SQLExpr primaryRest(SQLExpr expr) {
        if (this.lexer.token() == Token.COLON) {
            this.lexer.nextToken();
            if (this.lexer.token() == Token.LITERAL_INT && expr instanceof SQLPropertyExpr) {
                SQLPropertyExpr propertyExpr = (SQLPropertyExpr)expr;
                Number integerValue = this.lexer.integerValue();
                this.lexer.nextToken();
                propertyExpr.setName(propertyExpr.getName() + ':' + integerValue.intValue());
                return propertyExpr;
            }
            expr = this.dotRest(expr);
            return expr;
        }
        if (this.lexer.token() == Token.LBRACKET) {
            SQLArrayExpr array = new SQLArrayExpr();
            array.setExpr(expr);
            this.lexer.nextToken();
            this.exprList(array.getValues(), array);
            this.accept(Token.RBRACKET);
            return this.primaryRest(array);
        }
        if ((this.lexer.token() == Token.LITERAL_CHARS || this.lexer.token() == Token.LITERAL_ALIAS) && expr instanceof SQLCharExpr) {
            SQLCharExpr charExpr = new SQLCharExpr(this.lexer.stringVal());
            this.lexer.nextTokenValue();
            SQLMethodInvokeExpr concat = new SQLMethodInvokeExpr("concat", null, expr, charExpr);
            while (this.lexer.token() == Token.LITERAL_CHARS || this.lexer.token() == Token.LITERAL_ALIAS) {
                charExpr = new SQLCharExpr(this.lexer.stringVal());
                this.lexer.nextToken();
                concat.addArgument(charExpr);
            }
            expr = concat;
        }
        if (this.lexer.token() == Token.LPAREN && expr instanceof SQLIdentifierExpr && ((SQLIdentifierExpr)expr).nameHashCode64() == FnvHash.Constants.TRANSFORM) {
            SQLExternalRecordFormat recordFormat;
            OdpsTransformExpr transformExpr = new OdpsTransformExpr();
            this.lexer.nextToken();
            this.exprList(transformExpr.getInputColumns(), transformExpr);
            this.accept(Token.RPAREN);
            if (this.lexer.identifierEquals(FnvHash.Constants.ROW)) {
                recordFormat = this.parseRowFormat();
                transformExpr.setInputRowFormat(recordFormat);
            }
            if (this.lexer.token() == Token.USING || this.lexer.identifierEquals(FnvHash.Constants.USING)) {
                this.lexer.nextToken();
                transformExpr.setUsing(this.expr());
            }
            if (this.lexer.identifierEquals(FnvHash.Constants.RESOURCES)) {
                this.lexer.nextToken();
                this.exprList(transformExpr.getResources(), transformExpr);
            }
            if (this.lexer.token() == Token.AS) {
                this.lexer.nextToken();
                List<SQLColumnDefinition> outputColumns = transformExpr.getOutputColumns();
                if (this.lexer.token() == Token.LPAREN) {
                    this.lexer.nextToken();
                    while (true) {
                        SQLColumnDefinition column = this.parseColumn();
                        outputColumns.add(column);
                        if (this.lexer.token() != Token.COMMA) break;
                        this.lexer.nextToken();
                    }
                    this.accept(Token.RPAREN);
                } else {
                    SQLColumnDefinition column = new SQLColumnDefinition();
                    column.setName(this.name());
                    outputColumns.add(column);
                }
            }
            if (this.lexer.identifierEquals(FnvHash.Constants.ROW)) {
                recordFormat = this.parseRowFormat();
                transformExpr.setOutputRowFormat(recordFormat);
            }
            return transformExpr;
        }
        if (expr instanceof SQLIdentifierExpr && ((SQLIdentifierExpr)expr).nameHashCode64() == FnvHash.Constants.NEW) {
            SQLIdentifierExpr ident = (SQLIdentifierExpr)expr;
            OdpsNewExpr newExpr = new OdpsNewExpr();
            if (this.lexer.token() == Token.IDENTIFIER) {
                Lexer.SavePoint mark = this.lexer.mark();
                String methodName = this.lexer.stringVal();
                this.lexer.nextToken();
                switch (this.lexer.token()) {
                    case ON: 
                    case WHERE: 
                    case GROUP: 
                    case ORDER: 
                    case INNER: 
                    case JOIN: 
                    case FULL: 
                    case OUTER: 
                    case LEFT: 
                    case RIGHT: 
                    case LATERAL: 
                    case FROM: 
                    case COMMA: 
                    case RPAREN: {
                        return ident;
                    }
                }
                while (this.lexer.token() == Token.DOT) {
                    this.lexer.nextToken();
                    methodName = methodName + '.' + this.lexer.stringVal();
                    this.lexer.nextToken();
                }
                newExpr.setMethodName(methodName);
                if (this.lexer.token() == Token.LT) {
                    this.lexer.nextToken();
                    while (this.lexer.token() != Token.GT) {
                        SQLDataType paramType = this.parseDataType(false);
                        paramType.setParent(newExpr);
                        newExpr.getTypeParameters().add(paramType);
                        if (this.lexer.token() != Token.COMMA) break;
                        this.lexer.nextToken();
                    }
                    this.accept(Token.GT);
                }
                if (this.lexer.token() == Token.LBRACKET) {
                    this.lexer.nextToken();
                    this.exprList(newExpr.getArguments(), newExpr);
                    this.accept(Token.RBRACKET);
                    if (this.lexer.token() == Token.LBRACKET) {
                        this.lexer.nextToken();
                        this.accept(Token.RBRACKET);
                    }
                    newExpr.setArray(true);
                    if (this.lexer.token() == Token.LBRACE) {
                        this.lexer.nextToken();
                        while (this.lexer.token() != Token.RPAREN) {
                            SQLExpr item = this.expr();
                            newExpr.getInitValues().add(item);
                            item.setParent(newExpr);
                            if (this.lexer.token() != Token.COMMA) break;
                            this.lexer.nextToken();
                        }
                        this.accept(Token.RBRACE);
                    }
                    expr = this.lexer.token() == Token.LBRACKET ? this.primaryRest(newExpr) : newExpr;
                } else {
                    this.accept(Token.LPAREN);
                    this.exprList(newExpr.getArguments(), newExpr);
                    this.accept(Token.RPAREN);
                    expr = newExpr;
                }
            } else if (this.lexer.identifierEquals("java") || this.lexer.identifierEquals("com")) {
                SQLName name = this.name();
                String strName = ident.getName() + ' ' + name.toString();
                if (this.lexer.token() == Token.LT) {
                    this.lexer.nextToken();
                    int i = 0;
                    while (this.lexer.token() != Token.GT) {
                        if (i != 0) {
                            strName = strName + ", ";
                        }
                        SQLName arg = this.name();
                        strName = strName + arg.toString();
                        ++i;
                    }
                    this.lexer.nextToken();
                }
                ident.setName(strName);
            }
        }
        if (expr == null) {
            return null;
        }
        return super.primaryRest(expr);
    }

    @Override
    public SQLExpr relationalRest(SQLExpr expr) {
        if (this.lexer.identifierEquals("REGEXP")) {
            this.lexer.nextToken();
            SQLExpr rightExp = this.bitOr();
            rightExp = this.relationalRest(rightExp);
            return new SQLBinaryOpExpr(expr, SQLBinaryOperator.RegExp, rightExp, this.dbType);
        }
        return super.relationalRest(expr);
    }

    @Override
    public OdpsSelectParser createSelectParser() {
        return new OdpsSelectParser(this);
    }

    static {
        String[] strings = new String[]{"AVG", "COUNT", "LAG", "LEAD", "MAX", "MIN", "STDDEV", "SUM", "ROW_NUMBER", "WM_CONCAT", "STRAGG", "COLLECT_LIST", "COLLECT_SET"};
        AGGREGATE_FUNCTIONS_CODES = FnvHash.fnv1a_64_lower(strings, true);
        AGGREGATE_FUNCTIONS = new String[AGGREGATE_FUNCTIONS_CODES.length];
        for (String str : strings) {
            long hash = FnvHash.fnv1a_64_lower(str);
            int index = Arrays.binarySearch(AGGREGATE_FUNCTIONS_CODES, hash);
            OdpsExprParser.AGGREGATE_FUNCTIONS[index] = str;
        }
        GSONBUILDER = FnvHash.fnv1a_64_lower("GSONBUILDER");
    }
}

