/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.dialect.h2.visitor;

import com.aliyun.lindorm.client.shaded.com.alibaba.druid.DbType;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.ast.SQLExpr;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.ast.expr.SQLQueryExpr;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.ast.statement.SQLCreateDatabaseStatement;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.ast.statement.SQLCreateIndexStatement;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.ast.statement.SQLInsertStatement;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.ast.statement.SQLReplaceStatement;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.dialect.h2.visitor.H2ASTVisitor;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.visitor.SQLASTOutputVisitor;
import java.util.List;

public class H2OutputVisitor
extends SQLASTOutputVisitor
implements H2ASTVisitor {
    public H2OutputVisitor(Appendable appender) {
        super(appender, DbType.h2);
    }

    public H2OutputVisitor(Appendable appender, DbType dbType) {
        super(appender, dbType);
    }

    public H2OutputVisitor(Appendable appender, boolean parameterized) {
        super(appender, parameterized);
        this.dbType = DbType.h2;
    }

    @Override
    public boolean visit(SQLReplaceStatement x) {
        SQLQueryExpr query;
        List<SQLInsertStatement.ValuesClause> valuesClauseList;
        int size;
        this.print0(this.ucase ? "MERGE INTO " : "merge into ");
        this.printTableSourceExpr(x.getTableName());
        List<SQLExpr> columns = x.getColumns();
        if (columns.size() > 0) {
            this.print0(this.ucase ? " KEY (" : " key (");
            size = columns.size();
            for (int i = 0; i < size; ++i) {
                if (i != 0) {
                    this.print0(", ");
                }
                SQLExpr columnn = columns.get(i);
                this.printExpr(columnn, this.parameterized);
            }
            this.print(')');
        }
        if (!(valuesClauseList = x.getValuesList()).isEmpty()) {
            this.println();
            this.print0(this.ucase ? "VALUES " : "values ");
            size = valuesClauseList.size();
            if (size == 0) {
                this.print0("()");
            } else {
                for (int i = 0; i < size; ++i) {
                    if (i != 0) {
                        this.print0(", ");
                    }
                    this.visit(valuesClauseList.get(i));
                }
            }
        }
        if ((query = x.getQuery()) != null) {
            this.visit(query);
        }
        return false;
    }

    @Override
    public boolean visit(SQLCreateDatabaseStatement x) {
        this.printUcase("CREATE SCHEMA ");
        if (x.isIfNotExists()) {
            this.printUcase("IF NOT EXISTS ");
        }
        x.getName().accept(this);
        return false;
    }

    @Override
    public boolean visit(SQLCreateIndexStatement x) {
        this.printUcase("CREATE ");
        String type = x.getType();
        if ("UNIQUE".equalsIgnoreCase(type) || "SPATIAL".equalsIgnoreCase(type)) {
            this.printUcase(type + ' ');
        }
        this.printUcase("INDEX ");
        if (x.isIfNotExists()) {
            this.printUcase("IF NOT EXISTS ");
        }
        x.getName().accept(this);
        this.printUcase(" ON ");
        x.getTable().accept(this);
        this.print0(" (");
        this.printAndAccept(x.getItems(), ", ");
        this.print(')');
        return false;
    }
}

