/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.dialect.h2.parser;

import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.ast.expr.SQLDefaultExpr;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.ast.expr.SQLIntegerExpr;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.ast.statement.SQLColumnDefinition;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.dialect.h2.parser.H2Lexer;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.parser.Lexer;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.parser.SQLExprParser;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.parser.SQLParserFeature;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.parser.Token;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.util.FnvHash;
import java.util.Arrays;

public class H2ExprParser
extends SQLExprParser {
    private static final String[] AGGREGATE_FUNCTIONS;
    private static final long[] AGGREGATE_FUNCTIONS_CODES;

    public H2ExprParser(String sql) {
        this(new H2Lexer(sql));
        this.lexer.nextToken();
    }

    public H2ExprParser(String sql, SQLParserFeature ... features) {
        this(new H2Lexer(sql, features));
        this.lexer.nextToken();
    }

    public H2ExprParser(Lexer lexer) {
        super(lexer);
        this.dbType = lexer.getDbType();
        this.aggregateFunctions = AGGREGATE_FUNCTIONS;
        this.aggregateFunctionHashCodes = AGGREGATE_FUNCTIONS_CODES;
    }

    @Override
    public SQLColumnDefinition parseColumnRest(SQLColumnDefinition column) {
        column = super.parseColumnRest(column);
        if (this.lexer.identifierEquals(FnvHash.Constants.GENERATED)) {
            this.lexer.nextToken();
            if (this.lexer.token() == Token.BY) {
                this.lexer.nextToken();
                this.accept(Token.DEFAULT);
                column.setGeneratedAlawsAs(new SQLDefaultExpr());
            } else {
                this.acceptIdentifier("ALWAYS");
                column.setGeneratedAlawsAs(new SQLIdentifierExpr("ALWAYS"));
            }
            this.accept(Token.AS);
            this.acceptIdentifier("IDENTITY");
            SQLColumnDefinition.Identity identity = new SQLColumnDefinition.Identity();
            if (this.lexer.token() == Token.LPAREN) {
                this.lexer.nextToken();
                SQLIntegerExpr seed = (SQLIntegerExpr)this.primary();
                this.accept(Token.COMMA);
                SQLIntegerExpr increment = (SQLIntegerExpr)this.primary();
                this.accept(Token.RPAREN);
                identity.setSeed((Integer)seed.getNumber());
                identity.setIncrement((Integer)increment.getNumber());
            }
            column.setIdentity(identity);
        }
        return column;
    }

    static {
        String[] strings = new String[]{"AVG", "COUNT", "MAX", "MIN", "STDDEV", "SUM", "ROW_NUMBER", "ROWNUMBER"};
        AGGREGATE_FUNCTIONS_CODES = FnvHash.fnv1a_64_lower(strings, true);
        AGGREGATE_FUNCTIONS = new String[AGGREGATE_FUNCTIONS_CODES.length];
        for (String str : strings) {
            long hash = FnvHash.fnv1a_64_lower(str);
            int index = Arrays.binarySearch(AGGREGATE_FUNCTIONS_CODES, hash);
            H2ExprParser.AGGREGATE_FUNCTIONS[index] = str;
        }
    }
}

