/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.dialect.clickhouse.parser;

import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.ast.SQLExpr;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.ast.expr.SQLArrayExpr;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.ast.expr.SQLCharExpr;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.dialect.clickhouse.parser.ClickhouseLexer;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.parser.Lexer;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.parser.SQLExprParser;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.parser.SQLParserFeature;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.parser.Token;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.util.FnvHash;
import java.util.Arrays;

public class ClickhouseExprParser
extends SQLExprParser {
    private static final String[] AGGREGATE_FUNCTIONS;
    private static final long[] AGGREGATE_FUNCTIONS_CODES;

    public ClickhouseExprParser(String sql) {
        this(new ClickhouseLexer(sql));
        this.lexer.nextToken();
    }

    public ClickhouseExprParser(String sql, SQLParserFeature ... features) {
        this(new ClickhouseLexer(sql, features));
        this.lexer.nextToken();
    }

    public ClickhouseExprParser(Lexer lexer) {
        super(lexer);
        this.aggregateFunctions = AGGREGATE_FUNCTIONS;
        this.aggregateFunctionHashCodes = AGGREGATE_FUNCTIONS_CODES;
    }

    @Override
    protected SQLExpr parseAliasExpr(String alias) {
        String chars = alias.substring(1, alias.length() - 1);
        return new SQLCharExpr(chars);
    }

    @Override
    public SQLExpr primaryRest(SQLExpr expr) {
        if (this.lexer.token() == Token.LBRACKET) {
            SQLArrayExpr array = new SQLArrayExpr();
            array.setExpr(expr);
            this.lexer.nextToken();
            this.exprList(array.getValues(), array);
            this.accept(Token.RBRACKET);
            return this.primaryRest(array);
        }
        return super.primaryRest(expr);
    }

    static {
        String[] strings = new String[]{"AVG", "COUNT", "MAX", "MIN", "STDDEV", "SUM", "ROW_NUMBER", "ROWNUMBER"};
        AGGREGATE_FUNCTIONS_CODES = FnvHash.fnv1a_64_lower(strings, true);
        AGGREGATE_FUNCTIONS = new String[AGGREGATE_FUNCTIONS_CODES.length];
        for (String str : strings) {
            long hash = FnvHash.fnv1a_64_lower(str);
            int index = Arrays.binarySearch(AGGREGATE_FUNCTIONS_CODES, hash);
            ClickhouseExprParser.AGGREGATE_FUNCTIONS[index] = str;
        }
    }
}

