/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.ast.expr;

import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.SQLUtils;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.ast.SQLCommentHint;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.ast.SQLDataType;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.ast.SQLExpr;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.ast.SQLExprImpl;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.ast.SQLObject;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.ast.SQLReplaceable;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.ast.expr.SQLBooleanExpr;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.ast.expr.SQLCharExpr;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class SQLInListExpr
extends SQLExprImpl
implements SQLReplaceable,
Serializable {
    private static final long serialVersionUID = 1L;
    private boolean not;
    private SQLExpr expr;
    private List<SQLExpr> targetList = new ArrayList<SQLExpr>();
    protected SQLCommentHint hint;

    public SQLInListExpr() {
    }

    public SQLInListExpr(SQLExpr expr) {
        this.setExpr(expr);
    }

    public SQLInListExpr(String expr, String ... values) {
        this.setExpr(SQLUtils.toSQLExpr(expr));
        for (String value : values) {
            this.targetList.add(new SQLCharExpr(value));
        }
    }

    public SQLInListExpr(SQLExpr expr, boolean not) {
        this.setExpr(expr);
        this.not = not;
    }

    @Override
    public SQLInListExpr clone() {
        SQLInListExpr x = new SQLInListExpr();
        x.not = this.not;
        if (this.expr != null) {
            x.setExpr(this.expr.clone());
        }
        for (SQLExpr e : this.targetList) {
            SQLExpr e2 = e.clone();
            e2.setParent(x);
            x.targetList.add(e2);
        }
        return x;
    }

    public boolean isNot() {
        return this.not;
    }

    public void setNot(boolean not) {
        this.not = not;
    }

    public SQLExpr getExpr() {
        return this.expr;
    }

    public void setExpr(SQLExpr expr) {
        if (expr != null) {
            expr.setParent(this);
        }
        this.expr = expr;
    }

    public void addTarget(SQLExpr x) {
        x.setParent(this);
        this.targetList.add(x);
    }

    public void addTarget(int index, SQLExpr x) {
        x.setParent(this);
        this.targetList.add(index, x);
    }

    public List<SQLExpr> getTargetList() {
        return this.targetList;
    }

    public boolean sortTargetList() {
        if (this.targetList.size() < 2) {
            return true;
        }
        Class<?> firstClass = this.targetList.get(0).getClass();
        for (int i = 1; i < this.targetList.size(); ++i) {
            if (this.targetList.get(i).getClass() == firstClass) continue;
            return false;
        }
        if (!Comparable.class.isAssignableFrom(firstClass)) {
            return false;
        }
        Collections.sort(this.targetList);
        return true;
    }

    public void setTargetList(List<SQLExpr> targetList) {
        this.targetList = targetList;
    }

    @Override
    protected void accept0(SQLASTVisitor visitor) {
        if (visitor.visit(this)) {
            if (this.expr != null) {
                this.expr.accept(visitor);
            }
            if (this.targetList != null) {
                for (SQLExpr item : this.targetList) {
                    if (item == null) continue;
                    item.accept(visitor);
                }
            }
        }
        visitor.endVisit(this);
    }

    @Override
    public List<SQLObject> getChildren() {
        ArrayList<SQLObject> children = new ArrayList<SQLObject>();
        if (this.expr != null) {
            children.add(this.expr);
        }
        children.addAll(this.targetList);
        return children;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.expr == null ? 0 : this.expr.hashCode());
        result = 31 * result + (this.not ? 1231 : 1237);
        result = 31 * result + (this.targetList == null ? 0 : this.targetList.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SQLInListExpr other = (SQLInListExpr)obj;
        if (this.expr == null ? other.expr != null : !this.expr.equals(other.expr)) {
            return false;
        }
        if (this.not != other.not) {
            return false;
        }
        return !(this.targetList == null ? other.targetList != null : !this.targetList.equals(other.targetList));
    }

    @Override
    public SQLDataType computeDataType() {
        return SQLBooleanExpr.DATA_TYPE;
    }

    @Override
    public boolean replace(SQLExpr expr, SQLExpr target) {
        if (this.expr == expr) {
            this.setExpr(target);
            return true;
        }
        for (int i = this.targetList.size() - 1; i >= 0; --i) {
            if (this.targetList.get(i) != expr) continue;
            if (target == null) {
                this.targetList.remove(i);
            } else {
                this.targetList.set(i, target);
                target.setParent(this);
            }
            return true;
        }
        return false;
    }

    @Override
    public SQLCommentHint getHint() {
        return this.hint;
    }

    @Override
    public void setHint(SQLCommentHint hint) {
        this.hint = hint;
    }
}

