/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.ast.expr;

import com.aliyun.lindorm.client.shaded.com.alibaba.druid.FastsqlException;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.SQLUtils;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.ast.SQLExprImpl;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.ast.expr.SQLCharExpr;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.ast.expr.SQLLiteralExpr;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.ast.expr.SQLValuableExpr;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.visitor.SQLASTVisitor;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.util.HexBin;
import java.io.IOException;

public class SQLHexExpr
extends SQLExprImpl
implements SQLLiteralExpr,
SQLValuableExpr {
    private final String hex;

    public SQLHexExpr(String hex) {
        this.hex = hex;
    }

    public String getHex() {
        return this.hex;
    }

    @Override
    public void output(Appendable buf) {
        try {
            buf.append("0x");
            buf.append(this.hex);
            String charset = (String)this.getAttribute("USING");
            if (charset != null) {
                buf.append(" USING ");
                buf.append(charset);
            }
        }
        catch (IOException ex) {
            throw new FastsqlException("output error", ex);
        }
    }

    @Override
    protected void accept0(SQLASTVisitor visitor) {
        visitor.visit(this);
        visitor.endVisit(this);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.hex == null ? 0 : this.hex.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SQLHexExpr other = (SQLHexExpr)obj;
        return !(this.hex == null ? other.hex != null : !this.hex.equals(other.hex));
    }

    public byte[] toBytes() {
        return HexBin.decode(this.hex);
    }

    @Override
    public SQLHexExpr clone() {
        return new SQLHexExpr(this.hex);
    }

    public byte[] getValue() {
        return this.toBytes();
    }

    public SQLCharExpr toCharExpr() {
        byte[] bytes = this.toBytes();
        if (bytes == null) {
            return null;
        }
        String str = new String(bytes, SQLUtils.UTF8);
        return new SQLCharExpr(str);
    }
}

