/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.ast.expr;

import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.ast.SQLDataType;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.ast.SQLDataTypeImpl;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.ast.SQLObject;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.ast.expr.SQLNumericLiteralExpr;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.ast.expr.SQLValuableExpr;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.util.Collections;
import java.util.List;

public class SQLFloatExpr
extends SQLNumericLiteralExpr
implements SQLValuableExpr,
Comparable<SQLFloatExpr> {
    public static final SQLDataType DATA_TYPE = new SQLDataTypeImpl("FLOAT");
    private float value;

    public SQLFloatExpr() {
    }

    public SQLFloatExpr(String value) {
        this.value = Float.parseFloat(value);
    }

    public SQLFloatExpr(float value) {
        this.value = value;
    }

    @Override
    public SQLFloatExpr clone() {
        return new SQLFloatExpr(this.value);
    }

    @Override
    public List<SQLObject> getChildren() {
        return Collections.emptyList();
    }

    @Override
    public Float getNumber() {
        return Float.valueOf(this.value);
    }

    @Override
    public Float getValue() {
        return Float.valueOf(this.value);
    }

    public void setValue(float value) {
        this.value = value;
    }

    @Override
    protected void accept0(SQLASTVisitor visitor) {
        visitor.visit(this);
        visitor.endVisit(this);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SQLFloatExpr that = (SQLFloatExpr)o;
        return Double.compare(that.value, this.value) == 0;
    }

    @Override
    public int hashCode() {
        long temp = Double.doubleToLongBits(this.value);
        return (int)(temp ^ temp >>> 32);
    }

    @Override
    public void setNumber(Number number) {
        if (number == null) {
            this.setValue(Float.NaN);
            return;
        }
        this.setValue(number.floatValue());
    }

    @Override
    public int compareTo(SQLFloatExpr o) {
        return Float.compare(this.value, o.value);
    }
}

