/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.ast.expr;

import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.ast.SQLDataType;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.ast.SQLDataTypeImpl;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.ast.SQLObject;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.ast.expr.SQLNumericLiteralExpr;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.ast.expr.SQLValuableExpr;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.util.Collections;
import java.util.List;

public class SQLDoubleExpr
extends SQLNumericLiteralExpr
implements SQLValuableExpr,
Comparable<SQLDoubleExpr> {
    public static final SQLDataType DATA_TYPE = new SQLDataTypeImpl("DOUBLE");
    private double value;

    public SQLDoubleExpr() {
    }

    public SQLDoubleExpr(String value) {
        this.value = Double.parseDouble(value);
    }

    public SQLDoubleExpr(double value) {
        this.value = value;
    }

    @Override
    public SQLDoubleExpr clone() {
        return new SQLDoubleExpr(this.value);
    }

    @Override
    public List<SQLObject> getChildren() {
        return Collections.emptyList();
    }

    @Override
    public Double getNumber() {
        return this.value;
    }

    @Override
    public Double getValue() {
        return this.value;
    }

    public void setValue(double value) {
        this.value = value;
    }

    @Override
    protected void accept0(SQLASTVisitor visitor) {
        visitor.visit(this);
        visitor.endVisit(this);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SQLDoubleExpr that = (SQLDoubleExpr)o;
        return Double.compare(that.value, this.value) == 0;
    }

    @Override
    public int hashCode() {
        long temp = Double.doubleToLongBits(this.value);
        return (int)(temp ^ temp >>> 32);
    }

    @Override
    public void setNumber(Number number) {
        if (number == null) {
            this.setValue(Double.NaN);
            return;
        }
        this.setValue(number.doubleValue());
    }

    @Override
    public int compareTo(SQLDoubleExpr o) {
        return Double.compare(this.value, o.value);
    }
}

