/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.ast;

import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.ast.SQLObjectImpl;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.visitor.SQLASTVisitor;

public class SQLAnnIndex
extends SQLObjectImpl {
    private int indexType;
    private int rtIndexType;
    private Distance distance;

    @Override
    public SQLAnnIndex clone() {
        SQLAnnIndex x = new SQLAnnIndex();
        x.indexType = this.indexType;
        x.rtIndexType = this.rtIndexType;
        x.distance = this.distance;
        return x;
    }

    @Override
    protected void accept0(SQLASTVisitor v) {
        v.visit(this);
        v.endVisit(this);
    }

    public void setIndexType(String type) {
        this.indexType = IndexType.of(type);
    }

    public void setIndexType(IndexType indexType, boolean state) {
        this.indexType = state ? (this.indexType |= indexType.mask) : (this.indexType &= ~indexType.mask);
    }

    public void setRtIndexType(IndexType indexType, boolean state) {
        this.rtIndexType = state ? (this.rtIndexType |= indexType.mask) : (this.rtIndexType &= ~indexType.mask);
    }

    public void setRtIndexType(String type) {
        this.rtIndexType = IndexType.of(type);
    }

    public int getIndexType() {
        return this.indexType;
    }

    public int getRtIndexType() {
        return this.rtIndexType;
    }

    public Distance getDistance() {
        return this.distance;
    }

    public void setDistance(Distance distance) {
        this.distance = distance;
    }

    public void setDistance(String distance) {
        if (distance == null) {
            this.distance = null;
            return;
        }
        if (distance.equalsIgnoreCase("Hamming")) {
            this.distance = Distance.Hamming;
        } else if (distance.equalsIgnoreCase("SquaredEuclidean")) {
            this.distance = Distance.SquaredEuclidean;
        } else if (distance.equalsIgnoreCase("DotProduct")) {
            this.distance = Distance.DotProduct;
        }
    }

    public static enum Distance {
        Hamming,
        SquaredEuclidean,
        DotProduct;

    }

    public static enum IndexType {
        Flat(1),
        FastIndex(2);

        public final int mask;

        private IndexType(int ordinal) {
            this.mask = 1 << ordinal;
        }

        private static int of(String type) {
            String[] items;
            if (type == null || type.length() == 0) {
                return 0;
            }
            int v = 0;
            for (String item : items = type.split(",")) {
                if (item.trim().equalsIgnoreCase("Flat")) {
                    v |= IndexType.Flat.mask;
                    continue;
                }
                if (!item.trim().equalsIgnoreCase("FastIndex") && !item.trim().equalsIgnoreCase("FAST_INDEX")) continue;
                v |= IndexType.FastIndex.mask;
            }
            return v;
        }
    }
}

