/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.lindorm.client.shaded.com.alibaba.druid.pool.xa;

import com.aliyun.lindorm.client.shaded.com.alibaba.druid.pool.xa.JtdsXAConnection;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.support.logging.Log;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.support.logging.LogFactory;
import java.lang.reflect.Method;
import java.sql.Connection;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import net.sourceforge.jtds.jdbc.XASupport;

public class JtdsXAResource
implements XAResource {
    private static final Log LOG = LogFactory.getLog(JtdsXAResource.class);
    private final Connection connection;
    private final JtdsXAConnection xaConnection;
    private String rmHost;
    private static Method method;

    public JtdsXAResource(JtdsXAConnection xaConnection, Connection connection) {
        this.xaConnection = xaConnection;
        this.connection = connection;
        if (method == null) {
            try {
                method = connection.getClass().getMethod("getRmHost", new Class[0]);
            }
            catch (Exception e) {
                LOG.error("getRmHost method error", e);
            }
        }
        if (method != null) {
            try {
                this.rmHost = (String)method.invoke((Object)connection, new Object[0]);
            }
            catch (Exception e) {
                LOG.error("getRmHost error", e);
            }
        }
    }

    protected JtdsXAConnection getResourceManager() {
        return this.xaConnection;
    }

    protected String getRmHost() {
        return this.rmHost;
    }

    @Override
    public void commit(Xid xid, boolean commit) throws XAException {
        XASupport.xa_commit((Connection)this.connection, (int)this.xaConnection.getXAConnectionID(), (Xid)xid, (boolean)commit);
    }

    @Override
    public void end(Xid xid, int flags) throws XAException {
        XASupport.xa_end((Connection)this.connection, (int)this.xaConnection.getXAConnectionID(), (Xid)xid, (int)flags);
    }

    @Override
    public void forget(Xid xid) throws XAException {
        XASupport.xa_forget((Connection)this.connection, (int)this.xaConnection.getXAConnectionID(), (Xid)xid);
    }

    @Override
    public int getTransactionTimeout() throws XAException {
        return 0;
    }

    @Override
    public boolean isSameRM(XAResource xares) throws XAException {
        return xares instanceof JtdsXAResource && ((JtdsXAResource)xares).getRmHost().equals(this.rmHost);
    }

    @Override
    public int prepare(Xid xid) throws XAException {
        return XASupport.xa_prepare((Connection)this.connection, (int)this.xaConnection.getXAConnectionID(), (Xid)xid);
    }

    @Override
    public Xid[] recover(int flags) throws XAException {
        return XASupport.xa_recover((Connection)this.connection, (int)this.xaConnection.getXAConnectionID(), (int)flags);
    }

    @Override
    public void rollback(Xid xid) throws XAException {
        XASupport.xa_rollback((Connection)this.connection, (int)this.xaConnection.getXAConnectionID(), (Xid)xid);
    }

    @Override
    public boolean setTransactionTimeout(int seconds) throws XAException {
        return false;
    }

    @Override
    public void start(Xid xid, int flags) throws XAException {
        XASupport.xa_start((Connection)this.connection, (int)this.xaConnection.getXAConnectionID(), (Xid)xid, (int)flags);
    }
}

