/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.lindorm.client.shaded.com.alibaba.druid.pool.ha.selector;

import com.aliyun.lindorm.client.shaded.com.alibaba.druid.pool.DruidDataSource;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.pool.ha.HighAvailableDataSource;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.pool.ha.selector.DataSourceSelectorEnum;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.pool.ha.selector.RandomDataSourceSelector;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.pool.ha.selector.StickyDataSourceHolder;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.support.logging.Log;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.support.logging.LogFactory;
import javax.sql.DataSource;

public class StickyRandomDataSourceSelector
extends RandomDataSourceSelector {
    private static final Log LOG = LogFactory.getLog(StickyRandomDataSourceSelector.class);
    private ThreadLocal<StickyDataSourceHolder> holders = new ThreadLocal();
    private int expireSeconds = 5;

    public StickyRandomDataSourceSelector(HighAvailableDataSource highAvailableDataSource) {
        super(highAvailableDataSource);
    }

    @Override
    public String getName() {
        return DataSourceSelectorEnum.STICKY_RANDOM.getName();
    }

    @Override
    public DataSource get() {
        StickyDataSourceHolder holder = this.holders.get();
        if (holder != null && this.isAvailable(holder)) {
            LOG.debug("Return the sticky DataSource " + holder.getDataSource().toString() + " directly.");
            return holder.getDataSource();
        }
        LOG.debug("Return a random DataSource.");
        DataSource dataSource = super.get();
        holder = new StickyDataSourceHolder(dataSource);
        this.holders.remove();
        this.holders.set(holder);
        return dataSource;
    }

    private boolean isAvailable(StickyDataSourceHolder holder) {
        boolean flag;
        boolean bl = flag = this.isValid(holder) && !this.isExpired(holder);
        if (flag && holder.getDataSource() instanceof DruidDataSource) {
            flag = ((DruidDataSource)holder.getDataSource()).getPoolingCount() > 0;
        }
        return flag;
    }

    private boolean isValid(StickyDataSourceHolder holder) {
        boolean flag;
        boolean bl = flag = holder.isValid() && !this.getBlacklist().contains(holder.getDataSource());
        if (!(holder.getDataSource() instanceof DruidDataSource) || !flag) {
            return flag;
        }
        DruidDataSource dataSource = (DruidDataSource)holder.getDataSource();
        return flag && dataSource.getActiveCount() < dataSource.getMaxActive();
    }

    private boolean isExpired(StickyDataSourceHolder holder) {
        return System.currentTimeMillis() - holder.getRetrievingTime() > (long)(this.expireSeconds * 1000);
    }

    public int getExpireSeconds() {
        return this.expireSeconds;
    }

    public void setExpireSeconds(int expireSeconds) {
        this.expireSeconds = expireSeconds;
    }
}

