/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.lindorm.client.shaded.com.alibaba.druid.pool.ha.selector;

import com.aliyun.lindorm.client.shaded.com.alibaba.druid.pool.DruidDataSource;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.pool.ha.selector.RandomDataSourceSelector;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.proxy.jdbc.DataSourceProxy;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.support.logging.Log;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.support.logging.LogFactory;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.util.JdbcUtils;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.util.StringUtils;
import java.sql.Connection;
import java.sql.Driver;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.sql.DataSource;

public class RandomDataSourceValidateThread
implements Runnable {
    public static final int DEFAULT_CHECKING_INTERVAL_SECONDS = 10;
    public static final int DEFAULT_BLACKLIST_THRESHOLD = 3;
    private static final Log LOG = LogFactory.getLog(RandomDataSourceValidateThread.class);
    private static Map<String, Long> successTimes = new ConcurrentHashMap<String, Long>();
    private int checkingIntervalSeconds = 10;
    private int validationSleepSeconds;
    private int blacklistThreshold = 3;
    private RandomDataSourceSelector selector;
    private ExecutorService checkExecutor = Executors.newFixedThreadPool(5);
    private Map<String, Integer> errorCounts = new ConcurrentHashMap<String, Integer>();
    private Map<String, Long> lastCheckTimes = new ConcurrentHashMap<String, Long>();

    public static void logSuccessTime(DataSourceProxy dataSource) {
        if (dataSource != null && !StringUtils.isEmpty(dataSource.getName())) {
            String name = dataSource.getName();
            long time = System.currentTimeMillis();
            LOG.debug("Log successTime [" + time + "] for " + name);
            successTimes.put(name, time);
        }
    }

    public RandomDataSourceValidateThread(RandomDataSourceSelector selector) {
        LOG.debug("Create a RandomDataSourceValidateThread, hashCode=" + this.hashCode());
        this.selector = selector;
    }

    @Override
    public void run() {
        while (this.selector != null) {
            this.checkAllDataSources();
            this.maintainBlacklist();
            this.cleanup();
            this.sleepForNextValidation();
        }
    }

    private void sleepForNextValidation() {
        int errorCountBelowThreshold = 0;
        for (int count : this.errorCounts.values()) {
            if (count <= 0 || count >= this.blacklistThreshold || count <= errorCountBelowThreshold) continue;
            errorCountBelowThreshold = count;
        }
        int newSleepSeconds = this.checkingIntervalSeconds / (errorCountBelowThreshold + 1);
        if (newSleepSeconds < 1) {
            newSleepSeconds = 1;
        }
        try {
            LOG.debug("[RandomDataSourceValidateThread@" + this.hashCode() + "] Sleep " + newSleepSeconds + " second(s) until next checking.");
            Thread.sleep(newSleepSeconds * 1000);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void cleanup() {
        Map<String, DataSource> dataSourceMap = this.selector.getFullDataSourceMap();
        HashSet<String> dataSources = new HashSet<String>();
        for (DataSource ds : dataSourceMap.values()) {
            if (!(ds instanceof DruidDataSource)) continue;
            dataSources.add(((DruidDataSource)ds).getName());
        }
        this.cleanupMap(successTimes, dataSources);
        this.cleanupMap(this.errorCounts, dataSources);
        this.cleanupMap(this.lastCheckTimes, dataSources);
    }

    private void cleanupMap(Map<String, ?> mapToClean, Set<String> keys) {
        HashSet<String> keysToRemove = new HashSet<String>();
        for (String k : mapToClean.keySet()) {
            if (keys.contains(k)) continue;
            keysToRemove.add(k);
        }
        for (String k : keysToRemove) {
            mapToClean.remove(k);
        }
    }

    private void maintainBlacklist() {
        Map<String, DataSource> dataSourceMap = this.selector.getFullDataSourceMap();
        for (String name : this.errorCounts.keySet()) {
            Integer count = this.errorCounts.get(name);
            DataSource dataSource = dataSourceMap.get(name);
            if (dataSource == null) {
                for (DataSource ds : dataSourceMap.values()) {
                    if (!(ds instanceof DruidDataSource) || !name.equals(((DruidDataSource)ds).getName())) continue;
                    dataSource = ds;
                }
            }
            if (count == null || count <= 0) {
                this.selector.removeBlacklist(dataSource);
                continue;
            }
            if (count == null || count < this.blacklistThreshold || this.selector.containInBlacklist(dataSource)) continue;
            LOG.warn("Adding " + name + " to blacklist.");
            this.selector.addBlacklist(dataSource);
        }
    }

    private void checkAllDataSources() {
        Map<String, DataSource> dataSourceMap = this.selector.getFullDataSourceMap();
        ArrayList<1> tasks = new ArrayList<1>();
        LOG.debug("Checking all DataSource(s).");
        for (final Map.Entry<String, DataSource> e : dataSourceMap.entrySet()) {
            if (!(e.getValue() instanceof DruidDataSource)) continue;
            if (this.selector.containInBlacklist(e.getValue())) {
                LOG.debug(e.getKey() + " is already in blacklist, skip.");
                continue;
            }
            tasks.add(new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    DruidDataSource dataSource = (DruidDataSource)e.getValue();
                    String name = dataSource.getName();
                    if (RandomDataSourceValidateThread.this.isSkipChecking(dataSource)) {
                        LOG.debug("Skip checking DataSource[" + name + "] this time.");
                        return true;
                    }
                    LOG.debug("Start checking " + name + ".");
                    boolean flag = RandomDataSourceValidateThread.this.check(dataSource);
                    if (flag) {
                        RandomDataSourceValidateThread.logSuccessTime(dataSource);
                        RandomDataSourceValidateThread.this.errorCounts.put(name, 0);
                    } else {
                        if (!RandomDataSourceValidateThread.this.errorCounts.containsKey(name)) {
                            RandomDataSourceValidateThread.this.errorCounts.put(name, 0);
                        }
                        int count = (Integer)RandomDataSourceValidateThread.this.errorCounts.get(name);
                        RandomDataSourceValidateThread.this.errorCounts.put(name, count + 1);
                    }
                    RandomDataSourceValidateThread.this.lastCheckTimes.put(name, System.currentTimeMillis());
                    return flag;
                }
            });
        }
        try {
            this.checkExecutor.invokeAll(tasks);
        }
        catch (Exception e) {
            LOG.warn("Exception occurred while checking DataSource.", e);
        }
    }

    private boolean isSkipChecking(DruidDataSource dataSource) {
        String name = dataSource.getName();
        Long lastSuccessTime = successTimes.get(dataSource.getName());
        Long lastCheckTime = this.lastCheckTimes.get(dataSource.getName());
        long currentTime = System.currentTimeMillis();
        LOG.debug("DataSource=" + name + ", lastSuccessTime=" + lastSuccessTime + ", lastCheckTime=" + lastCheckTime + ", currentTime=" + currentTime);
        return lastSuccessTime != null && lastCheckTime != null && currentTime - lastSuccessTime <= (long)(this.checkingIntervalSeconds * 1000) && currentTime - lastCheckTime <= (long)(5 * this.checkingIntervalSeconds * 1000) && (!this.errorCounts.containsKey(name) || this.errorCounts.get(name) < 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean check(DruidDataSource dataSource) {
        boolean result = true;
        String name = dataSource.getName();
        Driver driver = dataSource.getRawDriver();
        Properties info = new Properties(dataSource.getConnectProperties());
        String username = dataSource.getUsername();
        String password = dataSource.getPassword();
        String url = dataSource.getUrl();
        Connection conn = null;
        if (info.getProperty("user") == null && username != null) {
            info.setProperty("user", username);
        }
        if (info.getProperty("password") == null && password != null) {
            info.setProperty("password", password);
        }
        try {
            LOG.debug("[RandomDataSourceValidateThread@" + this.hashCode() + "] Validating " + name + " every " + this.checkingIntervalSeconds + " seconds.");
            conn = driver.connect(url, info);
            this.sleepBeforeValidation();
            dataSource.validateConnection(conn);
        }
        catch (Exception e) {
            try {
                LOG.warn("Validation FAILED for " + name + " with url [" + url + "] and username [" + info.getProperty("user") + "]. Exception: " + e.getMessage());
                result = false;
            }
            catch (Throwable throwable) {
                JdbcUtils.close(conn);
                throw throwable;
            }
            JdbcUtils.close(conn);
        }
        JdbcUtils.close(conn);
        return result;
    }

    private void sleepBeforeValidation() {
        if (this.validationSleepSeconds <= 0) {
            return;
        }
        try {
            LOG.debug("Sleep " + this.validationSleepSeconds + " second(s) before validation.");
            Thread.sleep((long)this.validationSleepSeconds * 1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public int getCheckingIntervalSeconds() {
        return this.checkingIntervalSeconds;
    }

    public void setCheckingIntervalSeconds(int checkingIntervalSeconds) {
        this.checkingIntervalSeconds = checkingIntervalSeconds;
    }

    public int getValidationSleepSeconds() {
        return this.validationSleepSeconds;
    }

    public void setValidationSleepSeconds(int validationSleepSeconds) {
        this.validationSleepSeconds = validationSleepSeconds;
    }

    public int getBlacklistThreshold() {
        return this.blacklistThreshold;
    }

    public void setBlacklistThreshold(int blacklistThreshold) {
        this.blacklistThreshold = blacklistThreshold;
    }

    public RandomDataSourceSelector getSelector() {
        return this.selector;
    }

    public void setSelector(RandomDataSourceSelector selector) {
        this.selector = selector;
    }
}

