/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.lindorm.client.shaded.com.alibaba.druid.pool.ha.selector;

import com.aliyun.lindorm.client.shaded.com.alibaba.druid.pool.ha.HighAvailableDataSource;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.pool.ha.selector.DataSourceSelector;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.pool.ha.selector.DataSourceSelectorEnum;
import java.util.Iterator;
import java.util.Map;
import javax.sql.DataSource;

public class NamedDataSourceSelector
implements DataSourceSelector {
    public static final String DEFAULT_NAME = "default";
    private HighAvailableDataSource highAvailableDataSource;
    private ThreadLocal<String> targetDataSourceName = new ThreadLocal();
    private String defaultName = "default";

    public NamedDataSourceSelector(HighAvailableDataSource highAvailableDataSource) {
        this.highAvailableDataSource = highAvailableDataSource;
    }

    @Override
    public void init() {
    }

    @Override
    public void destroy() {
    }

    @Override
    public String getName() {
        return DataSourceSelectorEnum.BY_NAME.getName();
    }

    @Override
    public DataSource get() {
        Iterator<DataSource> iterator;
        if (this.highAvailableDataSource == null) {
            return null;
        }
        Map<String, DataSource> dataSourceMap = this.highAvailableDataSource.getAvailableDataSourceMap();
        if (dataSourceMap == null || dataSourceMap.isEmpty()) {
            return null;
        }
        if (dataSourceMap.size() == 1 && (iterator = dataSourceMap.values().iterator()).hasNext()) {
            DataSource v = iterator.next();
            return v;
        }
        String name = this.getTarget();
        if (name == null) {
            if (dataSourceMap.get(this.getDefaultName()) != null) {
                return dataSourceMap.get(this.getDefaultName());
            }
        } else {
            return dataSourceMap.get(name);
        }
        return null;
    }

    @Override
    public void setTarget(String name) {
        this.targetDataSourceName.set(name);
    }

    public String getTarget() {
        return this.targetDataSourceName.get();
    }

    public void resetDataSourceName() {
        this.targetDataSourceName.remove();
    }

    public String getDefaultName() {
        return this.defaultName;
    }

    public void setDefaultName(String defaultName) {
        this.defaultName = defaultName;
    }
}

