/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.lindorm.client.shaded.com.alibaba.druid.pool.ha.selector;

import com.aliyun.lindorm.client.shaded.com.alibaba.druid.pool.ha.HighAvailableDataSource;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.pool.ha.selector.DataSourceSelector;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.pool.ha.selector.NamedDataSourceSelector;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.pool.ha.selector.RandomDataSourceSelector;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.pool.ha.selector.StickyRandomDataSourceSelector;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.support.logging.Log;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.support.logging.LogFactory;

public enum DataSourceSelectorEnum {
    BY_NAME("byName", NamedDataSourceSelector.class),
    RANDOM("random", RandomDataSourceSelector.class),
    STICKY_RANDOM("stickyRandom", StickyRandomDataSourceSelector.class);

    private static final Log LOG;
    private String name;
    private Class<? extends DataSourceSelector> clazz;

    private DataSourceSelectorEnum(String name, Class<? extends DataSourceSelector> clazz) {
        this.name = name;
        this.clazz = clazz;
    }

    public DataSourceSelector newInstance(HighAvailableDataSource dataSource) {
        if (dataSource == null) {
            LOG.warn("You should provide an instance of HighAvailableDataSource!");
            return null;
        }
        DataSourceSelector selector = null;
        try {
            selector = this.clazz.getDeclaredConstructor(HighAvailableDataSource.class).newInstance(dataSource);
        }
        catch (Exception e) {
            LOG.error("Can not create new instance of " + this.clazz.getName(), e);
        }
        return selector;
    }

    public String getName() {
        return this.name;
    }

    public Class<? extends DataSourceSelector> getClazz() {
        return this.clazz;
    }

    static {
        LOG = LogFactory.getLog(DataSourceSelectorEnum.class);
    }
}

