/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.lindorm.client.shaded.com.alibaba.druid.pool.ha;

import com.aliyun.lindorm.client.shaded.com.alibaba.druid.filter.Filter;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.pool.DruidAbstractDataSource;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.pool.DruidDataSource;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.pool.WrapperAdapter;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.pool.ha.node.FileNodeListener;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.pool.ha.node.NodeListener;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.pool.ha.node.PoolUpdater;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.pool.ha.selector.DataSourceSelector;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.pool.ha.selector.DataSourceSelectorEnum;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.pool.ha.selector.DataSourceSelectorFactory;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.support.logging.Log;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.support.logging.LogFactory;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Logger;
import javax.sql.DataSource;

public class HighAvailableDataSource
extends WrapperAdapter
implements DataSource {
    private static final Log LOG = LogFactory.getLog(HighAvailableDataSource.class);
    private static final String DEFAULT_DATA_SOURCE_FILE = "ha-datasource.properties";
    private String driverClassName;
    private Properties connectProperties = new Properties();
    private String connectionProperties;
    private int initialSize = 0;
    private int maxActive = 8;
    private int minIdle = 0;
    private long maxWait = -1L;
    private String validationQuery = DruidAbstractDataSource.DEFAULT_VALIDATION_QUERY;
    private int validationQueryTimeout = -1;
    private boolean testOnBorrow = false;
    private boolean testOnReturn = false;
    private boolean testWhileIdle = true;
    private boolean poolPreparedStatements;
    private boolean sharePreparedStatements;
    private int maxPoolPreparedStatementPerConnectionSize = 10;
    private int queryTimeout;
    private int transactionQueryTimeout;
    private long timeBetweenEvictionRunsMillis = 60000L;
    private long minEvictableIdleTimeMillis = 1800000L;
    private long maxEvictableIdleTimeMillis = 25200000L;
    private long phyTimeoutMillis = -1L;
    private long timeBetweenConnectErrorMillis = 500L;
    private boolean removeAbandoned;
    private long removeAbandonedTimeoutMillis = 300000L;
    private boolean logAbandoned;
    private String filters;
    private List<Filter> proxyFilters = new CopyOnWriteArrayList<Filter>();
    private PrintWriter logWriter = new PrintWriter(System.out);
    private Map<String, DataSource> dataSourceMap = new ConcurrentHashMap<String, DataSource>();
    private Set<String> blacklist = new CopyOnWriteArraySet<String>();
    private DataSourceSelector selector;
    private String dataSourceFile = "ha-datasource.properties";
    private String propertyPrefix = "";
    private int poolPurgeIntervalSeconds = 60;
    private boolean allowEmptyPoolWhenUpdate;
    private volatile boolean inited;
    private PoolUpdater poolUpdater = new PoolUpdater(this);
    private NodeListener nodeListener;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        if (this.inited) {
            return;
        }
        HighAvailableDataSource highAvailableDataSource = this;
        synchronized (highAvailableDataSource) {
            if (this.inited) {
                return;
            }
            if (this.dataSourceMap == null || this.dataSourceMap.isEmpty()) {
                this.poolUpdater.setIntervalSeconds(this.poolPurgeIntervalSeconds);
                this.poolUpdater.setAllowEmptyPool(this.allowEmptyPoolWhenUpdate);
                this.poolUpdater.init();
                this.createNodeMap();
            }
            if (this.selector == null) {
                this.setSelector(DataSourceSelectorEnum.RANDOM.getName());
            }
            if (this.dataSourceMap == null || this.dataSourceMap.isEmpty()) {
                LOG.warn("There is NO DataSource available!!! Please check your configuration.");
            }
            this.inited = true;
        }
    }

    public void close() {
        this.destroy();
    }

    public void destroy() {
        if (this.nodeListener != null) {
            this.nodeListener.destroy();
        }
        if (this.poolUpdater != null) {
            this.poolUpdater.destroy();
        }
        if (this.selector != null) {
            this.selector.destroy();
        }
        if (this.dataSourceMap == null || this.dataSourceMap.isEmpty()) {
            return;
        }
        for (DataSource dataSource : this.dataSourceMap.values()) {
            if (!(dataSource instanceof DruidDataSource)) continue;
            ((DruidDataSource)dataSource).close();
        }
    }

    public void setTargetDataSource(String targetName) {
        this.selector.setTarget(targetName);
    }

    @Override
    public Connection getConnection() throws SQLException {
        this.init();
        DataSource dataSource = this.selector.get();
        if (dataSource == null) {
            LOG.warn("Can NOT obtain DataSource, return null.");
            return null;
        }
        return dataSource.getConnection();
    }

    public String getDataSourceFile() {
        return this.dataSourceFile;
    }

    public void setDataSourceFile(String dataSourceFile) {
        this.dataSourceFile = dataSourceFile;
    }

    public String getPropertyPrefix() {
        return this.propertyPrefix;
    }

    public void setPropertyPrefix(String propertyPrefix) {
        this.propertyPrefix = propertyPrefix;
    }

    public void setDataSourceMap(Map<String, DataSource> dataSourceMap) {
        if (dataSourceMap != null) {
            this.dataSourceMap = dataSourceMap;
        }
    }

    public Map<String, DataSource> getDataSourceMap() {
        return this.dataSourceMap;
    }

    public Map<String, DataSource> getAvailableDataSourceMap() {
        ConcurrentHashMap<String, DataSource> map = new ConcurrentHashMap<String, DataSource>(this.dataSourceMap);
        for (String n : this.blacklist) {
            if (!map.containsKey(n)) continue;
            map.remove(n);
        }
        return map;
    }

    public void addBlackList(String name) {
        if (this.dataSourceMap.containsKey(name)) {
            this.blacklist.add(name);
        } else {
            LOG.info("Key " + name + " is NOT existed, ignore it.");
        }
    }

    public void removeBlackList(String name) {
        this.blacklist.remove(name);
    }

    public boolean isInBlackList(String name) {
        return this.blacklist.contains(name);
    }

    public void setSelector(String name) {
        DataSourceSelector selector = DataSourceSelectorFactory.getSelector(name, this);
        if (selector != null) {
            selector.init();
            this.setDataSourceSelector(selector);
        }
    }

    public String getSelector() {
        return this.selector == null ? null : this.selector.getName();
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        throw new UnsupportedOperationException("Not supported by HighAvailableDataSource.");
    }

    @Override
    public void setLoginTimeout(int seconds) {
        DriverManager.setLoginTimeout(seconds);
    }

    @Override
    public int getLoginTimeout() {
        return DriverManager.getLoginTimeout();
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }

    public void setConnectionProperties(String connectionProperties) {
        this.connectionProperties = connectionProperties;
        if (connectionProperties == null || connectionProperties.trim().length() == 0) {
            this.setConnectProperties(null);
            return;
        }
        String[] entries = connectionProperties.split(";");
        Properties properties = new Properties();
        for (int i = 0; i < entries.length; ++i) {
            String entry = entries[i];
            if (entry.length() <= 0) continue;
            int index = entry.indexOf(61);
            if (index > 0) {
                String name = entry.substring(0, index);
                String value = entry.substring(index + 1);
                properties.setProperty(name, value);
                continue;
            }
            properties.setProperty(entry, "");
        }
        this.setConnectProperties(properties);
    }

    public void setConnectProperties(Properties connectProperties) {
        if (connectProperties == null) {
            connectProperties = new Properties();
        }
        if (this.connectProperties != null) {
            this.connectProperties.putAll((Map<?, ?>)connectProperties);
        } else {
            this.connectProperties = connectProperties;
        }
    }

    private void createNodeMap() {
        if (this.nodeListener == null) {
            FileNodeListener listener = new FileNodeListener();
            listener.setFile(this.dataSourceFile);
            listener.setPrefix(this.propertyPrefix);
            this.nodeListener = listener;
        }
        this.nodeListener.setObserver(this.poolUpdater);
        this.nodeListener.init();
        this.nodeListener.update();
    }

    public boolean isAllowEmptyPoolWhenUpdate() {
        return this.allowEmptyPoolWhenUpdate;
    }

    public void setAllowEmptyPoolWhenUpdate(boolean allowEmptyPoolWhenUpdate) {
        this.allowEmptyPoolWhenUpdate = allowEmptyPoolWhenUpdate;
    }

    public int getPoolPurgeIntervalSeconds() {
        return this.poolPurgeIntervalSeconds;
    }

    public void setPoolPurgeIntervalSeconds(int poolPurgeIntervalSeconds) {
        this.poolPurgeIntervalSeconds = poolPurgeIntervalSeconds;
    }

    public NodeListener getNodeListener() {
        return this.nodeListener;
    }

    public void setNodeListener(NodeListener nodeListener) {
        this.nodeListener = nodeListener;
    }

    public DataSourceSelector getDataSourceSelector() {
        return this.selector;
    }

    public void setDataSourceSelector(DataSourceSelector dataSourceSelector) {
        this.selector = dataSourceSelector;
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.logWriter;
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.logWriter = out;
    }

    public String getDriverClassName() {
        return this.driverClassName;
    }

    public void setDriverClassName(String driverClassName) {
        this.driverClassName = driverClassName;
    }

    public Properties getConnectProperties() {
        return this.connectProperties;
    }

    public int getInitialSize() {
        return this.initialSize;
    }

    public void setInitialSize(int initialSize) {
        this.initialSize = initialSize;
    }

    public int getMaxActive() {
        return this.maxActive;
    }

    public void setMaxActive(int maxActive) {
        this.maxActive = maxActive;
    }

    public int getMinIdle() {
        return this.minIdle;
    }

    public void setMinIdle(int minIdle) {
        this.minIdle = minIdle;
    }

    public long getMaxWait() {
        return this.maxWait;
    }

    public void setMaxWait(long maxWait) {
        this.maxWait = maxWait;
    }

    public String getValidationQuery() {
        return this.validationQuery;
    }

    public void setValidationQuery(String validationQuery) {
        this.validationQuery = validationQuery;
    }

    public int getValidationQueryTimeout() {
        return this.validationQueryTimeout;
    }

    public void setValidationQueryTimeout(int validationQueryTimeout) {
        this.validationQueryTimeout = validationQueryTimeout;
    }

    public boolean isTestOnBorrow() {
        return this.testOnBorrow;
    }

    public void setTestOnBorrow(boolean testOnBorrow) {
        this.testOnBorrow = testOnBorrow;
    }

    public boolean isTestOnReturn() {
        return this.testOnReturn;
    }

    public void setTestOnReturn(boolean testOnReturn) {
        this.testOnReturn = testOnReturn;
    }

    public boolean isTestWhileIdle() {
        return this.testWhileIdle;
    }

    public void setTestWhileIdle(boolean testWhileIdle) {
        this.testWhileIdle = testWhileIdle;
    }

    public boolean isPoolPreparedStatements() {
        return this.poolPreparedStatements;
    }

    public void setPoolPreparedStatements(boolean poolPreparedStatements) {
        this.poolPreparedStatements = poolPreparedStatements;
    }

    public boolean isSharePreparedStatements() {
        return this.sharePreparedStatements;
    }

    public void setSharePreparedStatements(boolean sharePreparedStatements) {
        this.sharePreparedStatements = sharePreparedStatements;
    }

    public int getMaxPoolPreparedStatementPerConnectionSize() {
        return this.maxPoolPreparedStatementPerConnectionSize;
    }

    public void setMaxPoolPreparedStatementPerConnectionSize(int maxPoolPreparedStatementPerConnectionSize) {
        this.maxPoolPreparedStatementPerConnectionSize = maxPoolPreparedStatementPerConnectionSize;
    }

    public int getQueryTimeout() {
        return this.queryTimeout;
    }

    public void setQueryTimeout(int queryTimeout) {
        this.queryTimeout = queryTimeout;
    }

    public int getTransactionQueryTimeout() {
        return this.transactionQueryTimeout;
    }

    public void setTransactionQueryTimeout(int transactionQueryTimeout) {
        this.transactionQueryTimeout = transactionQueryTimeout;
    }

    public long getTimeBetweenEvictionRunsMillis() {
        return this.timeBetweenEvictionRunsMillis;
    }

    public void setTimeBetweenEvictionRunsMillis(long timeBetweenEvictionRunsMillis) {
        this.timeBetweenEvictionRunsMillis = timeBetweenEvictionRunsMillis;
    }

    public long getMinEvictableIdleTimeMillis() {
        return this.minEvictableIdleTimeMillis;
    }

    public void setMinEvictableIdleTimeMillis(long minEvictableIdleTimeMillis) {
        this.minEvictableIdleTimeMillis = minEvictableIdleTimeMillis;
    }

    public long getMaxEvictableIdleTimeMillis() {
        return this.maxEvictableIdleTimeMillis;
    }

    public void setMaxEvictableIdleTimeMillis(long maxEvictableIdleTimeMillis) {
        this.maxEvictableIdleTimeMillis = maxEvictableIdleTimeMillis;
    }

    public long getPhyTimeoutMillis() {
        return this.phyTimeoutMillis;
    }

    public void setPhyTimeoutMillis(long phyTimeoutMillis) {
        this.phyTimeoutMillis = phyTimeoutMillis;
    }

    public long getTimeBetweenConnectErrorMillis() {
        return this.timeBetweenConnectErrorMillis;
    }

    public void setTimeBetweenConnectErrorMillis(long timeBetweenConnectErrorMillis) {
        this.timeBetweenConnectErrorMillis = timeBetweenConnectErrorMillis;
    }

    public boolean isRemoveAbandoned() {
        return this.removeAbandoned;
    }

    public void setRemoveAbandoned(boolean removeAbandoned) {
        this.removeAbandoned = removeAbandoned;
    }

    public long getRemoveAbandonedTimeoutMillis() {
        return this.removeAbandonedTimeoutMillis;
    }

    public void setRemoveAbandonedTimeoutMillis(long removeAbandonedTimeoutMillis) {
        this.removeAbandonedTimeoutMillis = removeAbandonedTimeoutMillis;
    }

    public boolean isLogAbandoned() {
        return this.logAbandoned;
    }

    public void setLogAbandoned(boolean logAbandoned) {
        this.logAbandoned = logAbandoned;
    }

    public String getConnectionProperties() {
        return this.connectionProperties;
    }

    public String getFilters() {
        return this.filters;
    }

    public void setFilters(String filters) {
        this.filters = filters;
    }

    public List<Filter> getProxyFilters() {
        return this.proxyFilters;
    }

    public void setProxyFilters(List<Filter> proxyFilters) {
        this.proxyFilters = proxyFilters;
    }
}

