/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.lindorm.client.shaded.com.alibaba.druid.mock.handler;

import com.aliyun.lindorm.client.shaded.com.alibaba.druid.mock.MockPreparedStatement;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.mock.MockResultSet;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.mock.MockResultSetMetaData;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.mock.MockStatementBase;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.mock.handler.MockExecuteHandler;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.ast.SQLExpr;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.ast.SQLStatement;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.ast.expr.SQLBooleanExpr;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.ast.expr.SQLCharExpr;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.ast.expr.SQLIntegerExpr;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.ast.expr.SQLMethodInvokeExpr;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.ast.expr.SQLNCharExpr;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.ast.expr.SQLNullExpr;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.ast.expr.SQLNumberExpr;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.ast.expr.SQLNumericLiteralExpr;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.ast.expr.SQLVariantRefExpr;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.ast.statement.SQLSelectItem;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.ast.statement.SQLSelectQuery;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.ast.statement.SQLSelectStatement;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.ast.statement.SQLTableSource;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.dialect.mysql.ast.statement.CobarShowStatus;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.sql.dialect.mysql.parser.MySqlStatementParser;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.util.jdbc.ResultSetMetaDataBase;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.List;

public class MySqlMockExecuteHandlerImpl
implements MockExecuteHandler {
    @Override
    public ResultSet executeQuery(MockStatementBase statement, String sql) throws SQLException {
        MySqlStatementParser parser = new MySqlStatementParser(sql);
        List<SQLStatement> stmtList = parser.parseStatementList();
        if (stmtList.size() > 1) {
            throw new SQLException("not support multi-statment. " + sql);
        }
        if (stmtList.isEmpty()) {
            throw new SQLException("executeQueryError : " + sql);
        }
        SQLStatement stmt = stmtList.get(0);
        if (stmt instanceof CobarShowStatus) {
            return this.showStatus(statement);
        }
        if (!(stmt instanceof SQLSelectStatement)) {
            throw new SQLException("executeQueryError : " + sql);
        }
        SQLSelect select = ((SQLSelectStatement)stmt).getSelect();
        SQLSelectQuery query = select.getQuery();
        if (query instanceof SQLSelectQueryBlock) {
            return this.executeQuery(statement, (SQLSelectQueryBlock)query);
        }
        throw new SQLException("TODO");
    }

    public ResultSet executeQuery(MockStatementBase statement, SQLSelectQueryBlock query) throws SQLException {
        SQLTableSource from = query.getFrom();
        if (from instanceof SQLExprTableSource) {
            String ident;
            SQLExpr expr = ((SQLExprTableSource)from).getExpr();
            if (expr instanceof SQLIdentifierExpr && "dual".equalsIgnoreCase(ident = ((SQLIdentifierExpr)expr).getName())) {
                return this.executeQueryFromDual(statement, query);
            }
            throw new SQLException("TODO : " + query);
        }
        if (from == null) {
            return this.executeQueryFromDual(statement, query);
        }
        throw new SQLException("TODO");
    }

    public ResultSet showStatus(MockStatementBase statement) throws SQLException {
        MockResultSet rs = new MockResultSet(statement);
        MockResultSetMetaData metaData = rs.getMockMetaData();
        Object[] row = new Object[]{"on"};
        ResultSetMetaDataBase.ColumnMetaData column = new ResultSetMetaDataBase.ColumnMetaData();
        column.setColumnType(-9);
        metaData.getColumns().add(column);
        rs.getRows().add(row);
        return rs;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ResultSet executeQueryFromDual(MockStatementBase statement, SQLSelectQueryBlock query) throws SQLException {
        MockResultSet rs = statement.getConnection().getDriver().createMockResultSet(statement);
        MockResultSetMetaData metaData = rs.getMockMetaData();
        Object[] row = new Object[query.getSelectList().size()];
        int size = query.getSelectList().size();
        for (int i = 0; i < size; ++i) {
            ResultSetMetaDataBase.ColumnMetaData column = new ResultSetMetaDataBase.ColumnMetaData();
            SQLSelectItem item = query.getSelectList().get(i);
            SQLExpr expr = item.getExpr();
            if (expr instanceof SQLIntegerExpr) {
                row[i] = ((SQLNumericLiteralExpr)expr).getNumber();
                column.setColumnType(4);
            } else if (expr instanceof SQLNumberExpr) {
                row[i] = ((SQLNumericLiteralExpr)expr).getNumber();
                column.setColumnType(3);
            } else if (expr instanceof SQLCharExpr) {
                row[i] = ((SQLCharExpr)expr).getText();
                column.setColumnType(12);
            } else if (expr instanceof SQLNCharExpr) {
                row[i] = ((SQLNCharExpr)expr).getText();
                column.setColumnType(-9);
            } else if (expr instanceof SQLBooleanExpr) {
                row[i] = ((SQLBooleanExpr)expr).getBooleanValue();
                column.setColumnType(-9);
            } else if (expr instanceof SQLNullExpr) {
                row[i] = null;
            } else if (expr instanceof SQLMethodInvokeExpr) {
                SQLMethodInvokeExpr methodInvokeExpr = (SQLMethodInvokeExpr)expr;
                if (!"NOW".equalsIgnoreCase(methodInvokeExpr.getMethodName())) throw new SQLException("TODO");
                row[i] = new Timestamp(System.currentTimeMillis());
            } else if (expr instanceof SQLVariantRefExpr) {
                SQLVariantRefExpr varExpr = (SQLVariantRefExpr)expr;
                int varIndex = varExpr.getIndex();
                if (statement instanceof MockPreparedStatement) {
                    MockPreparedStatement mockPstmt = (MockPreparedStatement)statement;
                    row[i] = mockPstmt.getParameters().get(varIndex);
                } else {
                    row[i] = null;
                }
            } else {
                row[i] = null;
            }
            metaData.getColumns().add(column);
        }
        rs.getRows().add(row);
        return rs;
    }
}

