/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.lindorm.client.shaded.com.alibaba.druid.mock;

import com.aliyun.lindorm.client.shaded.com.alibaba.druid.mock.MockResultSetMetaData;
import com.aliyun.lindorm.client.shaded.com.alibaba.druid.util.jdbc.ResultSetBase;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class MockResultSet
extends ResultSetBase
implements ResultSet {
    private int rowIndex = -1;
    private List<Object[]> rows;

    public MockResultSet(Statement statement) {
        this(statement, new ArrayList<Object[]>());
    }

    public MockResultSet(Statement statement, List<Object[]> rows) {
        super(statement);
        this.rows = rows;
        this.metaData = new MockResultSetMetaData();
    }

    public List<Object[]> getRows() {
        return this.rows;
    }

    @Override
    public synchronized boolean next() throws SQLException {
        if (this.closed) {
            throw new SQLException();
        }
        if (this.rowIndex < this.rows.size() - 1) {
            ++this.rowIndex;
            return true;
        }
        return false;
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        if (this.closed) {
            throw new SQLException("resultSet closed");
        }
        return (MockResultSetMetaData)this.metaData;
    }

    public MockResultSetMetaData getMockMetaData() throws SQLException {
        return (MockResultSetMetaData)this.metaData;
    }

    @Override
    public Object getObjectInternal(int columnIndex) {
        Object[] row = this.rows.get(this.rowIndex);
        Object obj = row[columnIndex - 1];
        return obj;
    }

    @Override
    public synchronized boolean previous() throws SQLException {
        if (this.closed) {
            throw new SQLException();
        }
        if (this.rowIndex >= 0) {
            --this.rowIndex;
            return true;
        }
        return false;
    }

    @Override
    public void updateObject(int columnIndex, Object x) throws SQLException {
        Object[] row = this.rows.get(this.rowIndex);
        row[columnIndex - 1] = x;
    }
}

