/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.hitsdb.client.value.type;

public enum UserPrivilege {
    WRITE_ONLY(1),
    READ_ONLY(2),
    READ_WRITE(3),
    SUPER(7);

    private final byte id;

    private UserPrivilege(byte id) {
        this.id = id;
    }

    public byte id() {
        return this.id;
    }

    public static UserPrivilege fromId(int id) {
        switch (id) {
            case 1: {
                return WRITE_ONLY;
            }
            case 2: {
                return READ_ONLY;
            }
            case 3: {
                return READ_WRITE;
            }
            case 7: {
                return SUPER;
            }
        }
        throw new IllegalArgumentException("No privilege match for id [" + id + "]");
    }

    public static UserPrivilege fromString(String privilege) {
        if ("writeonly".equals(privilege)) {
            return WRITE_ONLY;
        }
        if ("readonly".equals(privilege)) {
            return READ_ONLY;
        }
        if ("readwrite".equals(privilege)) {
            return READ_WRITE;
        }
        if ("super".equals(privilege)) {
            return SUPER;
        }
        throw new IllegalArgumentException("No privilege match for string [" + privilege + "]");
    }

    public boolean canRead() {
        return (this.id & UserPrivilege.READ_ONLY.id) == UserPrivilege.READ_ONLY.id;
    }

    public boolean canWrite() {
        return (this.id & UserPrivilege.WRITE_ONLY.id) == UserPrivilege.WRITE_ONLY.id;
    }

    public boolean isSuper() {
        return this.id == UserPrivilege.SUPER.id;
    }
}

