/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.hitsdb.client.value.request;

import com.aliyun.hitsdb.client.value.JSONValue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Timeline
extends JSONValue {
    private String metric;
    private Map<String, String> tags;
    private List<String> fields = null;

    public static Builder metric(String metric) {
        return new Builder(metric);
    }

    public List<String> getFields() {
        return this.fields;
    }

    public void setFields(List<String> fields) {
        this.fields = fields;
    }

    public String getMetric() {
        return this.metric;
    }

    public void setMetric(String metric) {
        this.metric = metric;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public static class Builder {
        private String metric;
        private Map<String, String> tags = new HashMap<String, String>();
        private List<String> fields = null;

        public Builder(String metric) {
            this.metric = metric;
        }

        public Builder tag(String tagk, String tagv) {
            this.tags.put(tagk, tagv);
            return this;
        }

        public Builder tag(Map<String, String> tags) {
            this.tags.putAll(tags);
            return this;
        }

        public Builder fields(List<String> fields) {
            if (fields == null || fields.isEmpty()) {
                return this;
            }
            this.fields = new ArrayList<String>();
            this.fields.addAll(fields);
            return this;
        }

        public Timeline build() {
            Timeline timeline = new Timeline();
            timeline.metric = this.metric;
            timeline.tags = this.tags;
            if (this.fields != null && !this.fields.isEmpty()) {
                timeline.fields = this.fields;
            }
            return timeline;
        }
    }
}

