/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.hitsdb.client.value.request;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.annotation.JSONField;
import com.aliyun.hitsdb.client.util.Objects;
import com.aliyun.hitsdb.client.value.request.AbstractPoint;
import com.aliyun.hitsdb.client.value.request.FieldsSerializer;
import com.aliyun.hitsdb.client.value.request.PointType;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class MultiFieldPoint
extends AbstractPoint {
    @JSONField(serializeUsing=FieldsSerializer.class, deserializeUsing=FieldsSerializer.class)
    private Map<String, Object> fields;

    public static MetricBuilder metric(String name) {
        return new MetricBuilder(name);
    }

    @Override
    public PointType getPointType() {
        return PointType.MULTI_FIELD;
    }

    public Map<String, Object> getFields() {
        return this.fields;
    }

    public void setFields(Map<String, Object> fields) {
        this.fields = fields;
    }

    public static void checkPoint(MultiFieldPoint multiFieldPoint) {
        if (multiFieldPoint.metric == null || multiFieldPoint.metric.length() == 0) {
            throw new IllegalArgumentException("Metric can't be empty");
        }
        for (int i = 0; i < multiFieldPoint.metric.length(); ++i) {
            char c = multiFieldPoint.metric.charAt(i);
            if (MultiFieldPoint.checkChar(c)) continue;
            throw new IllegalArgumentException("There is an invalid character in metric. The char is '" + c + "'");
        }
        if (multiFieldPoint.timestamp == null) {
            throw new IllegalArgumentException("Timestamp can't be null");
        }
        MultiFieldPoint.checkTimestamp(multiFieldPoint.timestamp);
        if (multiFieldPoint.fields == null || multiFieldPoint.fields.isEmpty()) {
            throw new IllegalArgumentException("Fields can't be null or empty");
        }
        for (Map.Entry<String, Object> entry : multiFieldPoint.fields.entrySet()) {
            if (entry.getKey() == null || entry.getKey().isEmpty()) {
                throw new IllegalArgumentException("Field name can't be null or empty.");
            }
            for (int i = 0; i < entry.getKey().length(); ++i) {
                char c = entry.getKey().charAt(i);
                if (MultiFieldPoint.checkChar(c)) continue;
                throw new IllegalArgumentException("There is an invalid character in field. The char is '" + c + "'");
            }
            if (entry.getValue() == null) {
                throw new IllegalArgumentException("Field value can't be null or empty.");
            }
            if (entry.getValue() instanceof Number && entry.getValue() == Double.valueOf(Double.NaN)) {
                throw new IllegalArgumentException("Number field value can't be NaN");
            }
            if (entry.getValue() instanceof Number && entry.getValue() == Double.valueOf(Double.POSITIVE_INFINITY)) {
                throw new IllegalArgumentException("Number field value can't be POSITIVE_INFINITY");
            }
            if (!(entry.getValue() instanceof Number) || entry.getValue() != Double.valueOf(Double.NEGATIVE_INFINITY)) continue;
            throw new IllegalArgumentException("Number field value can't be NEGATIVE_INFINITY");
        }
        if (multiFieldPoint.getTags() != null && !multiFieldPoint.getTags().isEmpty()) {
            for (Map.Entry<String, Object> entry : multiFieldPoint.tags.entrySet()) {
                char c;
                int i;
                String tagkey = entry.getKey();
                String tagvalue = (String)entry.getValue();
                for (i = 0; i < tagkey.length(); ++i) {
                    c = tagkey.charAt(i);
                    if (MultiFieldPoint.checkChar(c)) continue;
                    throw new IllegalArgumentException("There is an invalid character in tagkey. the tagkey is + " + tagkey + ", the char is '" + c + "'");
                }
                for (i = 0; i < tagvalue.length(); ++i) {
                    c = tagvalue.charAt(i);
                    if (MultiFieldPoint.checkChar(c)) continue;
                    throw new IllegalArgumentException("There is an invalid character in tagvalue. the tag is + <" + tagkey + ":" + tagvalue + "> , the char is '" + c + "'");
                }
            }
        }
    }

    public static class MetricBuilder {
        private String metric;
        private Map<String, String> tags = new HashMap<String, String>();
        private Map<String, Object> fields = new HashMap<String, Object>();
        private Long timestamp;

        public MetricBuilder(String metric) {
            Objects.requireNonNull(metric, "metric name");
            if (metric.isEmpty()) {
                throw new IllegalArgumentException("Metric name cannot be empty.");
            }
            this.metric = metric;
        }

        public MetricBuilder tag(String tagName, String value) {
            Objects.requireNonNull(tagName, "tag key");
            Objects.requireNonNull(value, "tag value");
            if (!tagName.isEmpty()) {
                this.tags.put(tagName, value);
            }
            return this;
        }

        public MetricBuilder tags(Map<String, String> tags) {
            if (tags != null) {
                this.tags.putAll(tags);
            }
            return this;
        }

        public MetricBuilder timestamp(Long timestamp) {
            Objects.requireNonNull(timestamp, "timestamp");
            this.timestamp = timestamp;
            return this;
        }

        public MetricBuilder timestamp(long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public MetricBuilder timestamp(Date date) {
            Objects.requireNonNull(date, "date timestamp");
            this.timestamp = date.getTime();
            return this;
        }

        public MetricBuilder field(String fieldName, Object fieldValue) {
            Objects.requireNonNull(fieldName, "field name");
            if (fieldValue != null) {
                this.fields.put(fieldName, fieldValue);
            }
            return this;
        }

        public MetricBuilder fields(Map<String, Object> fields) {
            if (fields != null) {
                this.fields.putAll(fields);
            }
            return this;
        }

        public MultiFieldPoint build() {
            return this.build(true);
        }

        public MultiFieldPoint build(boolean checkPoint) {
            MultiFieldPoint multiFieldPoint = new MultiFieldPoint();
            multiFieldPoint.metric = this.metric;
            multiFieldPoint.tags = this.tags;
            multiFieldPoint.fields = this.fields;
            multiFieldPoint.timestamp = this.timestamp;
            if (checkPoint) {
                MultiFieldPoint.checkPoint(multiFieldPoint);
            }
            return multiFieldPoint;
        }

        private String buildJSON(MultiFieldPoint point) {
            return JSON.toJSONString((Object)point);
        }
    }
}

