/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.hitsdb.client.value.request;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.aliyun.hitsdb.client.value.JSONValue;
import com.aliyun.hitsdb.client.value.request.LookupTagFilter;
import java.util.ArrayList;
import java.util.List;

public class LookupRequest
extends JSONValue {
    private String metric;
    private List<LookupTagFilter> tags = new ArrayList<LookupTagFilter>();
    private Integer limit = null;

    public static Builder metric(String metric) {
        return new Builder(metric);
    }

    public static Builder tags(String key, String value) {
        return new Builder(key, value);
    }

    public static Builder tags(LookupTagFilter lookupTagFilter) {
        return new Builder(lookupTagFilter);
    }

    public static Builder tags(List<LookupTagFilter> lookupTagFilters) {
        return new Builder(lookupTagFilters);
    }

    public LookupRequest() {
    }

    public LookupRequest(String metric, List<LookupTagFilter> tags, int limit) {
        this.metric = metric;
        this.tags = tags;
        this.limit = limit;
    }

    public String getMetric() {
        return this.metric;
    }

    public List<LookupTagFilter> getTags() {
        return this.tags;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public void setMetric(String metric) {
        this.metric = metric;
    }

    public void setTags(List<LookupTagFilter> tags) {
        this.tags = tags;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    @Override
    public String toJSON() {
        return JSON.toJSONString((Object)this, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect});
    }

    public static class Builder {
        private String metric;
        private List<LookupTagFilter> tags = new ArrayList<LookupTagFilter>();
        private Integer limit = null;

        public Builder() {
        }

        public Builder(String metric) {
            this.metric = metric;
        }

        public Builder(String key, String value) {
            LookupTagFilter lookupTagFilter = new LookupTagFilter(key, value);
            this.tags.clear();
            this.tags.add(lookupTagFilter);
        }

        public Builder(List<LookupTagFilter> tags) {
            this.tags = tags;
        }

        public Builder(LookupTagFilter lookupTagFilter) {
            this.tags.clear();
            this.tags.add(lookupTagFilter);
        }

        public Builder metric(String metric) {
            this.metric = metric;
            return this;
        }

        public Builder tags(String key, String value) {
            LookupTagFilter lookupTagFilter = new LookupTagFilter(key, value);
            this.tags.add(lookupTagFilter);
            return this;
        }

        public Builder tags(List<LookupTagFilter> tags) {
            if (tags != null) {
                this.tags.addAll(tags);
            }
            return this;
        }

        public Builder tags(LookupTagFilter lookupTagFilter) {
            this.tags.add(lookupTagFilter);
            return this;
        }

        public Builder limit(int limit) {
            this.limit = limit;
            return this;
        }

        public LookupRequest build() {
            LookupRequest lookupRequest = new LookupRequest();
            lookupRequest.metric = this.metric;
            lookupRequest.tags = this.tags;
            lookupRequest.limit = this.limit;
            return lookupRequest;
        }
    }
}

