/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.hitsdb.client.util;

import com.aliyun.hitsdb.client.util.LinkedHashMapException;
import java.lang.reflect.Field;
import java.util.LinkedHashMap;
import java.util.Map;

public class LinkedHashMapUtils {
    private static final Field tailField;
    private static final Field beforeField;

    public static <K, V> Map.Entry<K, V> getTail(LinkedHashMap<K, V> map) throws LinkedHashMapException {
        try {
            Map.Entry entry = (Map.Entry)tailField.get(map);
            return entry;
        }
        catch (SecurityException e) {
            throw new LinkedHashMapException(e);
        }
        catch (IllegalArgumentException e) {
            throw new LinkedHashMapException(e);
        }
        catch (IllegalAccessException e) {
            throw new LinkedHashMapException(e);
        }
    }

    public static <K, V> Map.Entry<K, V> getBefore(Map.Entry<K, V> entry) throws LinkedHashMapException {
        try {
            Map.Entry beforeEntry = (Map.Entry)beforeField.get(entry);
            return beforeEntry;
        }
        catch (SecurityException e) {
            throw new LinkedHashMapException(e);
        }
        catch (IllegalArgumentException e) {
            throw new LinkedHashMapException(e);
        }
        catch (IllegalAccessException e) {
            throw new LinkedHashMapException(e);
        }
    }

    static {
        try {
            tailField = LinkedHashMap.class.getDeclaredField("tail");
            tailField.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            throw new LinkedHashMapException(e);
        }
        catch (SecurityException e) {
            throw new LinkedHashMapException(e);
        }
        try {
            Class<?> clazz = Class.forName("java.util.LinkedHashMap$Entry");
            beforeField = clazz.getDeclaredField("before");
            beforeField.setAccessible(true);
        }
        catch (ClassNotFoundException e) {
            throw new LinkedHashMapException(e);
        }
        catch (NoSuchFieldException e) {
            throw new LinkedHashMapException(e);
        }
        catch (SecurityException e) {
            throw new LinkedHashMapException(e);
        }
    }
}

