/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.hitsdb.client.callback.http;

import com.alibaba.fastjson.JSON;
import com.aliyun.hitsdb.client.Config;
import com.aliyun.hitsdb.client.callback.AbstractMultiFieldBatchPutCallback;
import com.aliyun.hitsdb.client.callback.MultiFieldBatchPutCallback;
import com.aliyun.hitsdb.client.callback.MultiFieldBatchPutDetailsCallback;
import com.aliyun.hitsdb.client.callback.MultiFieldBatchPutIgnoreErrorsCallback;
import com.aliyun.hitsdb.client.callback.MultiFieldBatchPutSummaryCallback;
import com.aliyun.hitsdb.client.callback.http.HttpResponseCallbackFactory;
import com.aliyun.hitsdb.client.exception.http.HttpClientConnectionRefusedException;
import com.aliyun.hitsdb.client.exception.http.HttpClientSocketTimeoutException;
import com.aliyun.hitsdb.client.exception.http.HttpServerErrorException;
import com.aliyun.hitsdb.client.exception.http.HttpServerNotSupportException;
import com.aliyun.hitsdb.client.exception.http.HttpUnknowStatusException;
import com.aliyun.hitsdb.client.http.HttpAddressManager;
import com.aliyun.hitsdb.client.http.HttpClient;
import com.aliyun.hitsdb.client.http.response.HttpStatus;
import com.aliyun.hitsdb.client.http.response.ResultResponse;
import com.aliyun.hitsdb.client.value.Result;
import com.aliyun.hitsdb.client.value.request.MultiFieldPoint;
import com.aliyun.hitsdb.client.value.response.batch.MultiFieldDetailsResult;
import com.aliyun.hitsdb.client.value.response.batch.MultiFieldIgnoreErrorsResult;
import com.aliyun.hitsdb.client.value.response.batch.SummaryResult;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.util.List;
import org.apache.http.HttpResponse;
import org.apache.http.concurrent.FutureCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiFieldBatchPutHttpResponseCallback
implements FutureCallback<HttpResponse> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MultiFieldBatchPutHttpResponseCallback.class);
    private final AbstractMultiFieldBatchPutCallback<?> multiFieldBatchPutCallback;
    private final List<MultiFieldPoint> pointList;
    private final int batchPutRetryTimes;
    private final boolean compress;
    private final HttpClient hitsdbHttpClient;
    private final Config config;
    private final String address;

    public MultiFieldBatchPutHttpResponseCallback(String address, HttpClient httpclient, AbstractMultiFieldBatchPutCallback<?> multiFieldBatchPutCallback, List<MultiFieldPoint> pointList, Config config, int batchPutRetryTimes) {
        this.address = address;
        this.hitsdbHttpClient = httpclient;
        this.multiFieldBatchPutCallback = multiFieldBatchPutCallback;
        this.pointList = pointList;
        this.batchPutRetryTimes = batchPutRetryTimes;
        this.compress = config.isHttpCompress();
        this.config = config;
    }

    public AbstractMultiFieldBatchPutCallback<?> getLogicalBatchPutCallback() {
        return this.multiFieldBatchPutCallback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void completed(HttpResponse httpResponse) {
        try {
            if (httpResponse.getStatusLine().getStatusCode() == 307) {
                this.hitsdbHttpClient.setSslEnable(true);
                if (this.errorRetry()) {
                    return;
                }
            }
            ResultResponse resultResponse = ResultResponse.simplify(httpResponse, this.compress);
            HttpStatus httpStatus = resultResponse.getHttpStatus();
            switch (httpStatus) {
                case ServerSuccess: 
                case ServerSuccessNoContent: {
                    if (this.multiFieldBatchPutCallback == null) {
                        return;
                    }
                    if (this.multiFieldBatchPutCallback instanceof MultiFieldBatchPutCallback) {
                        ((MultiFieldBatchPutCallback)this.multiFieldBatchPutCallback).response(this.address, this.pointList, new Result());
                        return;
                    }
                    if (this.multiFieldBatchPutCallback instanceof MultiFieldBatchPutSummaryCallback) {
                        SummaryResult summaryResult = null;
                        if (!httpStatus.equals((Object)HttpStatus.ServerSuccessNoContent)) {
                            String content = resultResponse.getContent();
                            summaryResult = (SummaryResult)JSON.parseObject((String)content, SummaryResult.class);
                        }
                        ((MultiFieldBatchPutSummaryCallback)this.multiFieldBatchPutCallback).response(this.address, this.pointList, summaryResult);
                        return;
                    }
                    if (this.multiFieldBatchPutCallback instanceof MultiFieldBatchPutDetailsCallback) {
                        MultiFieldDetailsResult detailsResult = null;
                        if (!httpStatus.equals((Object)HttpStatus.ServerSuccessNoContent)) {
                            String content = resultResponse.getContent();
                            detailsResult = (MultiFieldDetailsResult)JSON.parseObject((String)content, MultiFieldDetailsResult.class);
                        }
                        ((MultiFieldBatchPutDetailsCallback)this.multiFieldBatchPutCallback).response(this.address, this.pointList, detailsResult);
                        return;
                    }
                    if (this.multiFieldBatchPutCallback instanceof MultiFieldBatchPutIgnoreErrorsCallback) {
                        MultiFieldIgnoreErrorsResult ignoreErrorsResult = null;
                        if (!httpStatus.equals((Object)HttpStatus.ServerSuccessNoContent)) {
                            String content = resultResponse.getContent();
                            ignoreErrorsResult = (MultiFieldIgnoreErrorsResult)JSON.parseObject((String)content, MultiFieldIgnoreErrorsResult.class);
                        }
                        ((MultiFieldBatchPutIgnoreErrorsCallback)this.multiFieldBatchPutCallback).response(this.address, this.pointList, ignoreErrorsResult);
                        return;
                    }
                }
                case ServerNotSupport: {
                    HttpServerNotSupportException ex = new HttpServerNotSupportException(resultResponse);
                    this.failedWithResponse(ex);
                    return;
                }
                case ServerError: {
                    if (this.batchPutRetryTimes == 0) {
                        HttpServerErrorException ex = new HttpServerErrorException(resultResponse);
                        this.failedWithResponse(ex);
                    } else if (!this.errorRetry()) {
                        LOGGER.warn("batch put retry limit {} reached", (Object)this.batchPutRetryTimes);
                        HttpServerErrorException ex = new HttpServerErrorException(resultResponse);
                        this.failedWithResponse(ex);
                    }
                    return;
                }
            }
            HttpUnknowStatusException ex = new HttpUnknowStatusException(resultResponse);
            this.failedWithResponse(ex);
        }
        finally {
            this.hitsdbHttpClient.getSemaphoreManager().release(this.address);
        }
    }

    private void failedWithResponse(Exception ex) {
        if (this.multiFieldBatchPutCallback == null) {
            LOGGER.error("multi field no callback logic exception. address:" + this.address, (Throwable)ex);
        } else {
            this.multiFieldBatchPutCallback.failed(this.address, this.pointList, ex);
        }
    }

    private String getNextAddress() {
        HttpAddressManager httpAddressManager = this.hitsdbHttpClient.getHttpAddressManager();
        String newAddress = httpAddressManager.getAddress();
        return newAddress;
    }

    private boolean errorRetry() {
        String newAddress;
        boolean acquire;
        int retryTimes = this.batchPutRetryTimes;
        do {
            newAddress = this.getNextAddress();
        } while (!(acquire = this.hitsdbHttpClient.getSemaphoreManager().acquire(newAddress)) && --retryTimes > 0);
        if (retryTimes == 0) {
            this.hitsdbHttpClient.getSemaphoreManager().release(this.address);
            return false;
        }
        LOGGER.warn("retry put data!");
        HttpResponseCallbackFactory httpResponseCallbackFactory = this.hitsdbHttpClient.getHttpResponseCallbackFactory();
        FutureCallback<HttpResponse> retryCallback = this.multiFieldBatchPutCallback != null ? httpResponseCallbackFactory.createMultiFieldBatchPutDataCallback(newAddress, this.multiFieldBatchPutCallback, this.pointList, this.config, retryTimes) : httpResponseCallbackFactory.createMultiFieldNoLogicBatchPutHttpFutureCallback(newAddress, this.pointList, this.config, retryTimes);
        String jsonString = JSON.toJSONString(this.pointList);
        this.hitsdbHttpClient.post("/api/mput", jsonString, retryCallback);
        return true;
    }

    public void failed(Exception ex) {
        try {
            if (ex instanceof SocketTimeoutException) {
                if (this.batchPutRetryTimes == 0) {
                    ex = new HttpClientSocketTimeoutException(ex);
                } else if (this.errorRetry()) {
                    return;
                }
            } else if (ex instanceof ConnectException) {
                if (this.batchPutRetryTimes == 0) {
                    ex = new HttpClientConnectionRefusedException(this.address, ex);
                } else if (this.errorRetry()) {
                    return;
                }
            }
            if (this.multiFieldBatchPutCallback == null) {
                LOGGER.error("multi field no callback logic exception.", (Throwable)ex);
            } else {
                this.multiFieldBatchPutCallback.failed(this.address, this.pointList, ex);
            }
        }
        finally {
            this.hitsdbHttpClient.getSemaphoreManager().release(this.address);
        }
    }

    public void cancelled() {
        this.hitsdbHttpClient.getSemaphoreManager().release(this.address);
        LOGGER.info("the HttpAsyncClient has been cancelled");
    }
}

