/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.hitsdb.client.callback.http;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.http.HttpResponse;
import org.apache.http.concurrent.FutureCallback;

public class BaseHttpFutureCallback
implements FutureCallback<HttpResponse> {
    private final AtomicInteger unCompletedTaskNum;
    private final FutureCallback<HttpResponse> futureCallback;

    public BaseHttpFutureCallback(AtomicInteger unCompletedTaskNum, FutureCallback<HttpResponse> futureCallback) {
        this.unCompletedTaskNum = unCompletedTaskNum;
        this.futureCallback = futureCallback;
    }

    public void completed(HttpResponse result) {
        this.futureCallback.completed((Object)result);
        this.unCompletedTaskNum.decrementAndGet();
    }

    public void failed(Exception ex) {
        this.futureCallback.failed(ex);
        this.unCompletedTaskNum.decrementAndGet();
    }

    public void cancelled() {
        this.futureCallback.cancelled();
        this.unCompletedTaskNum.decrementAndGet();
    }
}

