/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.hitsdb.client;

import com.alibaba.fastjson.JSON;
import com.aliyun.hitsdb.client.Config;
import com.aliyun.hitsdb.client.TSDBClient;
import com.aliyun.hitsdb.client.exception.http.HttpClientInitException;
import com.aliyun.hitsdb.client.http.response.HttpStatus;
import com.aliyun.hitsdb.client.http.response.ResultResponse;
import com.aliyun.hitsdb.client.value.request.TagsAddInfo;
import com.aliyun.hitsdb.client.value.request.TagsRemoveInfo;
import com.aliyun.hitsdb.client.value.request.TagsShowInfo;
import com.aliyun.hitsdb.client.value.response.TagsAddResult;
import com.aliyun.hitsdb.client.value.response.TagsShowResult;
import java.util.List;
import org.apache.http.HttpResponse;

public class IotClient
extends TSDBClient {
    public IotClient(Config config) throws HttpClientInitException {
        super(config);
    }

    public TagsAddResult tagsAdd(TagsAddInfo tagsAddInfo) {
        HttpResponse httpResponse = this.httpclient.post("/api/tags/add", tagsAddInfo.toJSON());
        ResultResponse resultResponse = ResultResponse.simplify(httpResponse, this.httpCompress);
        HttpStatus httpStatus = resultResponse.getHttpStatus();
        switch (httpStatus) {
            case ServerSuccess: {
                String content = resultResponse.getContent();
                TagsAddResult result = (TagsAddResult)JSON.parseObject((String)content, TagsAddResult.class);
                return result;
            }
        }
        return (TagsAddResult)this.handleStatus(resultResponse);
    }

    public List<TagsShowResult> tagsShow(TagsShowInfo tagsShowInfo) {
        HttpResponse httpResponse = this.httpclient.post("/api/tags/show", tagsShowInfo.toJSON());
        ResultResponse resultResponse = ResultResponse.simplify(httpResponse, this.httpCompress);
        HttpStatus httpStatus = resultResponse.getHttpStatus();
        switch (httpStatus) {
            case ServerSuccess: {
                String content = resultResponse.getContent();
                List result = JSON.parseArray((String)content, TagsShowResult.class);
                return result;
            }
        }
        return (List)this.handleStatus(resultResponse);
    }

    public void tagsRemove(TagsRemoveInfo tagsRemoveInfo) {
        HttpResponse httpResponse = this.httpclient.post("/api/tags/remove", tagsRemoveInfo.toJSON());
        ResultResponse resultResponse = ResultResponse.simplify(httpResponse, this.httpCompress);
        this.handleVoid(resultResponse);
    }
}

