/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.sdk.android.oss.model;

import android.net.Uri;
import com.alibaba.sdk.android.oss.common.utils.OSSUtils;
import com.alibaba.sdk.android.oss.model.MultipartUploadRequest;
import com.alibaba.sdk.android.oss.model.ObjectMetadata;
import java.io.File;

public class ResumableUploadRequest
extends MultipartUploadRequest {
    private Boolean deleteUploadOnCancelling = true;
    private String recordDirectory;

    public ResumableUploadRequest(String bucketName, String objectKey, String uploadFilePath) {
        this(bucketName, objectKey, uploadFilePath, null, null);
    }

    public ResumableUploadRequest(String bucketName, String objectKey, String uploadFilePath, ObjectMetadata metadata) {
        this(bucketName, objectKey, uploadFilePath, metadata, null);
    }

    public ResumableUploadRequest(String bucketName, String objectKey, String uploadFilePath, String recordDirectory) {
        this(bucketName, objectKey, uploadFilePath, null, recordDirectory);
    }

    public ResumableUploadRequest(String bucketName, String objectKey, String uploadFilePath, ObjectMetadata metadata, String recordDirectory) {
        super(bucketName, objectKey, uploadFilePath, metadata);
        this.setRecordDirectory(recordDirectory);
    }

    public ResumableUploadRequest(String bucketName, String objectKey, Uri uploadUri) {
        this(bucketName, objectKey, uploadUri, null, null);
    }

    public ResumableUploadRequest(String bucketName, String objectKey, Uri uploadUri, ObjectMetadata metadata) {
        this(bucketName, objectKey, uploadUri, metadata, null);
    }

    public ResumableUploadRequest(String bucketName, String objectKey, Uri uploadUri, String recordDirectory) {
        this(bucketName, objectKey, uploadUri, null, recordDirectory);
    }

    public ResumableUploadRequest(String bucketName, String objectKey, Uri uploadUri, ObjectMetadata metadata, String recordDirectory) {
        super(bucketName, objectKey, uploadUri, metadata);
        this.setRecordDirectory(recordDirectory);
    }

    public String getRecordDirectory() {
        return this.recordDirectory;
    }

    public void setRecordDirectory(String recordDirectory) {
        File file;
        if (!(OSSUtils.isEmptyString(recordDirectory) || (file = new File(recordDirectory)).exists() && file.isDirectory())) {
            throw new IllegalArgumentException("Record directory must exist, and it should be a directory!");
        }
        this.recordDirectory = recordDirectory;
    }

    public Boolean deleteUploadOnCancelling() {
        return this.deleteUploadOnCancelling;
    }

    public void setDeleteUploadOnCancelling(Boolean deleteUploadOnCancelling) {
        this.deleteUploadOnCancelling = deleteUploadOnCancelling;
    }
}

