/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.sdk.android.oss.model;

import android.util.Xml;
import com.alibaba.sdk.android.oss.common.utils.DateUtil;
import com.alibaba.sdk.android.oss.common.utils.OSSUtils;
import com.alibaba.sdk.android.oss.internal.ResponseMessage;
import com.alibaba.sdk.android.oss.model.MultipartUpload;
import com.alibaba.sdk.android.oss.model.OSSResult;
import java.util.ArrayList;
import java.util.List;
import org.xmlpull.v1.XmlPullParser;

public class ListMultipartUploadsResult
extends OSSResult {
    private String bucketName;
    private String keyMarker;
    private String delimiter;
    private String prefix;
    private String uploadIdMarker;
    private int maxUploads;
    private boolean isTruncated;
    private String nextKeyMarker;
    private String nextUploadIdMarker;
    private List<MultipartUpload> multipartUploads = new ArrayList<MultipartUpload>();
    private List<String> commonPrefixes = new ArrayList<String>();

    public String getBucketName() {
        return this.bucketName;
    }

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    public String getKeyMarker() {
        return this.keyMarker;
    }

    public void setKeyMarker(String keyMarker) {
        this.keyMarker = keyMarker;
    }

    public String getUploadIdMarker() {
        return this.uploadIdMarker;
    }

    public void setUploadIdMarker(String uploadIdMarker) {
        this.uploadIdMarker = uploadIdMarker;
    }

    public String getNextKeyMarker() {
        return this.nextKeyMarker;
    }

    public void setNextKeyMarker(String nextKeyMarker) {
        this.nextKeyMarker = nextKeyMarker;
    }

    public String getNextUploadIdMarker() {
        return this.nextUploadIdMarker;
    }

    public void setNextUploadIdMarker(String nextUploadIdMarker) {
        this.nextUploadIdMarker = nextUploadIdMarker;
    }

    public int getMaxUploads() {
        return this.maxUploads;
    }

    public void setMaxUploads(int maxUploads) {
        this.maxUploads = maxUploads;
    }

    public boolean isTruncated() {
        return this.isTruncated;
    }

    public void setTruncated(boolean isTruncated) {
        this.isTruncated = isTruncated;
    }

    public List<MultipartUpload> getMultipartUploads() {
        return this.multipartUploads;
    }

    public void setMultipartUploads(List<MultipartUpload> multipartUploads) {
        this.multipartUploads.clear();
        if (multipartUploads != null && !multipartUploads.isEmpty()) {
            this.multipartUploads.addAll(multipartUploads);
        }
    }

    public void addMultipartUpload(MultipartUpload multipartUpload) {
        this.multipartUploads.add(multipartUpload);
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public List<String> getCommonPrefixes() {
        return this.commonPrefixes;
    }

    public void setCommonPrefixes(List<String> commonPrefixes) {
        this.commonPrefixes.clear();
        if (commonPrefixes != null && !commonPrefixes.isEmpty()) {
            this.commonPrefixes.addAll(commonPrefixes);
        }
    }

    public void addCommonPrefix(String commonPrefix) {
        this.commonPrefixes.add(commonPrefix);
    }

    public ListMultipartUploadsResult parseData(ResponseMessage responseMessage) throws Exception {
        ArrayList<MultipartUpload> uploadList = new ArrayList<MultipartUpload>();
        MultipartUpload upload = null;
        boolean isCommonPrefixes = false;
        XmlPullParser parser = Xml.newPullParser();
        parser.setInput(responseMessage.getContent(), "utf-8");
        int eventType = parser.getEventType();
        while (eventType != 1) {
            switch (eventType) {
                case 2: {
                    String name = parser.getName();
                    if ("Bucket".equals(name)) {
                        this.setBucketName(parser.nextText());
                        break;
                    }
                    if ("Delimiter".equals(name)) {
                        this.setDelimiter(parser.nextText());
                        break;
                    }
                    if ("Prefix".equals(name)) {
                        if (isCommonPrefixes) {
                            String commonPrefix = parser.nextText();
                            if (OSSUtils.isEmptyString(commonPrefix)) break;
                            this.addCommonPrefix(commonPrefix);
                            break;
                        }
                        this.setPrefix(parser.nextText());
                        break;
                    }
                    if ("MaxUploads".equals(name)) {
                        String maxUploads = parser.nextText();
                        if (OSSUtils.isEmptyString(maxUploads)) break;
                        this.setMaxUploads(Integer.valueOf(maxUploads));
                        break;
                    }
                    if ("IsTruncated".equals(name)) {
                        String isTruncated = parser.nextText();
                        if (OSSUtils.isEmptyString(isTruncated)) break;
                        this.setTruncated(Boolean.valueOf(isTruncated));
                        break;
                    }
                    if ("KeyMarker".equals(name)) {
                        this.setKeyMarker(parser.nextText());
                        break;
                    }
                    if ("UploadIdMarker".equals(name)) {
                        this.setUploadIdMarker(parser.nextText());
                        break;
                    }
                    if ("NextKeyMarker".equals(name)) {
                        this.setNextKeyMarker(parser.nextText());
                        break;
                    }
                    if ("NextUploadIdMarker".equals(name)) {
                        this.setNextUploadIdMarker(parser.nextText());
                        break;
                    }
                    if ("Upload".equals(name)) {
                        upload = new MultipartUpload();
                        break;
                    }
                    if ("Key".equals(name)) {
                        upload.setKey(parser.nextText());
                        break;
                    }
                    if ("UploadId".equals(name)) {
                        upload.setUploadId(parser.nextText());
                        break;
                    }
                    if ("Initiated".equals(name)) {
                        upload.setInitiated(DateUtil.parseIso8601Date(parser.nextText()));
                        break;
                    }
                    if ("StorageClass".equals(name)) {
                        upload.setStorageClass(parser.nextText());
                        break;
                    }
                    if (!"CommonPrefixes".equals(name)) break;
                    isCommonPrefixes = true;
                    break;
                }
                case 3: {
                    if ("Upload".equals(parser.getName())) {
                        uploadList.add(upload);
                        break;
                    }
                    if (!"CommonPrefixes".equals(parser.getName())) break;
                    isCommonPrefixes = false;
                }
            }
            if ((eventType = parser.next()) != 4) continue;
            eventType = parser.next();
        }
        if (uploadList.size() > 0) {
            this.setMultipartUploads(uploadList);
        }
        return this;
    }
}

