/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.auth.credentials.provider;

import com.aliyun.auth.credentials.Credential;
import com.aliyun.auth.credentials.ICredential;
import com.aliyun.auth.credentials.exception.CredentialException;
import com.aliyun.auth.credentials.http.CompatibleUrlConnClient;
import com.aliyun.auth.credentials.http.HttpRequest;
import com.aliyun.auth.credentials.http.HttpResponse;
import com.aliyun.auth.credentials.http.MethodType;
import com.aliyun.auth.credentials.provider.HttpCredentialProvider;
import com.aliyun.auth.credentials.utils.ParameterHelper;
import com.aliyun.auth.credentials.utils.RefreshResult;
import com.aliyun.core.utils.StringUtils;
import com.aliyun.core.utils.Validate;
import com.google.gson.Gson;
import java.net.MalformedURLException;
import java.net.URL;
import java.time.Instant;
import java.util.Map;

public final class EcsRamRoleCredentialProvider
extends HttpCredentialProvider {
    private static final String URL_IN_ECS_METADATA = "/latest/meta-data/ram/security-credentials/";
    private static final String ECS_METADAT_FETCH_ERROR_MSG = "Failed to get RAM session credentials from ECS metadata service.";
    private URL credentialUrl;
    private String roleName;
    private String metadataServiceHost;
    private int connectionTimeout;
    private int readTimeout;
    private int EcsRamRoleTimeout;

    private EcsRamRoleCredentialProvider(BuilderImpl builder) {
        super(builder);
        this.roleName = (String)Validate.notNull((Object)builder.roleName, (String)"roleName must not be null.", (Object[])new Object[0]);
        this.metadataServiceHost = builder.metadataServiceHost;
        this.connectionTimeout = builder.connectionTimeout;
        this.readTimeout = builder.readTimeout;
        this.EcsRamRoleTimeout = builder.EcsRamRoleTimeout;
        try {
            this.credentialUrl = new URL("http://" + this.metadataServiceHost + URL_IN_ECS_METADATA + this.roleName);
        }
        catch (MalformedURLException e) {
            throw new CredentialException(e.getMessage(), e);
        }
        this.buildRefreshCache();
    }

    public static EcsRamRoleCredentialProvider create(String roleName) {
        return EcsRamRoleCredentialProvider.builder().roleName(roleName).build();
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    @Override
    public RefreshResult<ICredential> refreshCredentials() {
        HttpResponse response;
        CompatibleUrlConnClient client = new CompatibleUrlConnClient();
        HttpRequest request = new HttpRequest(this.credentialUrl.toString());
        request.setSysMethod(MethodType.GET);
        request.setSysConnectTimeout(this.connectionTimeout);
        request.setSysReadTimeout(this.readTimeout);
        try {
            response = client.syncInvoke(request);
        }
        catch (Exception e) {
            throw new CredentialException("Failed to connect ECS Metadata Service: " + e.toString());
        }
        finally {
            client.close();
        }
        if (response.getResponseCode() == 404) {
            throw new CredentialException("The role name was not found in the instance");
        }
        if (response.getResponseCode() != 200) {
            throw new CredentialException("Failed to get RAM session credentials from ECS metadata service. HttpCode=" + response.getResponseCode());
        }
        Gson gson = new Gson();
        Map credentials = (Map)gson.fromJson(response.getHttpContentString(), Map.class);
        if (!"Success".equals(credentials.get("Code"))) {
            throw new CredentialException(ECS_METADAT_FETCH_ERROR_MSG);
        }
        Instant expiration = ParameterHelper.getUTCDate((String)credentials.get("Expiration")).toInstant();
        Credential credential = Credential.builder().accessKeyId((String)credentials.get("AccessKeyId")).accessKeySecret((String)credentials.get("AccessKeySecret")).securityToken((String)credentials.get("SecurityToken")).build();
        return RefreshResult.builder(credential).staleTime(this.getStaleTime(expiration)).prefetchTime(this.getPrefetchTime(expiration)).build();
    }

    private static final class BuilderImpl
    extends HttpCredentialProvider.BuilderImpl<EcsRamRoleCredentialProvider, Builder>
    implements Builder {
        private String roleName;
        private String metadataServiceHost = "100.100.100.200";
        private int connectionTimeout = 1000;
        private int readTimeout = 1000;
        private int EcsRamRoleTimeout = 1000;

        private BuilderImpl() {
        }

        @Override
        public Builder roleName(String roleName) {
            this.roleName = roleName;
            return this;
        }

        @Override
        public Builder metadataServiceHost(String metadataServiceHost) {
            if (!StringUtils.isEmpty((CharSequence)metadataServiceHost)) {
                this.metadataServiceHost = metadataServiceHost;
            }
            return this;
        }

        @Override
        public Builder connectionTimeout(int connectionTimeout) {
            if (!StringUtils.isEmpty((Object)connectionTimeout)) {
                this.connectionTimeout = connectionTimeout;
            }
            return this;
        }

        @Override
        public Builder readTimeout(int readTimeout) {
            if (!StringUtils.isEmpty((Object)readTimeout)) {
                this.readTimeout = readTimeout;
            }
            return this;
        }

        @Override
        public Builder EcsRamRoleTimeout(int EcsRamRoleTimeout) {
            if (!StringUtils.isEmpty((Object)EcsRamRoleTimeout)) {
                this.EcsRamRoleTimeout = EcsRamRoleTimeout;
            }
            return this;
        }

        @Override
        public EcsRamRoleCredentialProvider build() {
            return new EcsRamRoleCredentialProvider(this);
        }
    }

    public static interface Builder
    extends HttpCredentialProvider.Builder<EcsRamRoleCredentialProvider, Builder> {
        public Builder roleName(String var1);

        public Builder metadataServiceHost(String var1);

        public Builder connectionTimeout(int var1);

        public Builder readTimeout(int var1);

        public Builder EcsRamRoleTimeout(int var1);

        @Override
        public EcsRamRoleCredentialProvider build();
    }
}

