/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.auth.credentials.provider;

import com.aliyun.auth.credentials.ICredential;
import com.aliyun.auth.credentials.exception.CredentialException;
import com.aliyun.auth.credentials.provider.ICredentialProvider;
import com.aliyun.core.logging.ClientLogger;
import com.aliyun.core.utils.IOUtils;
import com.aliyun.core.utils.SdkAutoCloseable;
import com.aliyun.core.utils.StringUtils;
import com.aliyun.core.utils.Validate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class CredentialsProviderChain
implements ICredentialProvider,
SdkAutoCloseable {
    private static final ClientLogger logger = new ClientLogger(CredentialsProviderChain.class);
    private final List<ICredentialProvider> credentialsProviders;
    private final boolean reuseLastProviderEnabled;
    private volatile ICredentialProvider lastUsedProvider;

    private CredentialsProviderChain(Builder builder) {
        this.reuseLastProviderEnabled = builder.reuseLastProviderEnabled;
        this.credentialsProviders = Collections.unmodifiableList((List)Validate.notEmpty((Collection)builder.credentialsProviders, (String)"No credential provider.", (Object[])new Object[0]));
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public ICredential getCredentials() throws CredentialException {
        if (this.reuseLastProviderEnabled && this.lastUsedProvider != null) {
            return this.lastUsedProvider.getCredentials();
        }
        for (ICredentialProvider provider : this.credentialsProviders) {
            try {
                ICredential credentials = provider.getCredentials();
                logger.verbose("Loading credentials from " + provider);
                this.lastUsedProvider = provider;
                return credentials;
            }
            catch (RuntimeException e) {
                String message = provider + ": " + e.getMessage();
                logger.verbose("Unable to load credentials from " + message);
            }
        }
        throw new CredentialException("Unable to load credentials from any of the providers in the chain " + this);
    }

    public void close() {
        this.credentialsProviders.forEach(credentials -> IOUtils.closeIfCloseable((Object)credentials, (ClientLogger)logger));
    }

    public String toString() {
        HashMap<String, List<ICredentialProvider>> fieldMap = new HashMap<String, List<ICredentialProvider>>();
        fieldMap.put("credentialsProviders", this.credentialsProviders);
        return StringUtils.toAliString((String)"CredentialsProviderChain", fieldMap);
    }

    public static final class Builder {
        private List<ICredentialProvider> credentialsProviders = new ArrayList<ICredentialProvider>();
        private boolean reuseLastProviderEnabled = true;

        public Builder credentialsProviders(Collection<? extends ICredentialProvider> credentialsProviders) {
            this.credentialsProviders = new ArrayList<ICredentialProvider>(credentialsProviders);
            return this;
        }

        public Builder credentialsProviders(ICredentialProvider ... credentialsProviders) {
            return this.credentialsProviders(Arrays.asList(credentialsProviders));
        }

        public Builder reuseLastProviderEnabled(Boolean reuseLastProviderEnabled) {
            this.reuseLastProviderEnabled = reuseLastProviderEnabled;
            return this;
        }

        public Builder addCredentialsProvider(ICredentialProvider credentialsProviders) {
            this.credentialsProviders.add(credentialsProviders);
            return this;
        }

        public CredentialsProviderChain build() {
            return new CredentialsProviderChain(this);
        }
    }
}

