/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.server.bolt;

import com.alipay.remoting.AsyncContext;
import com.alipay.remoting.BizContext;
import com.alipay.remoting.InvokeContext;
import com.alipay.remoting.rpc.protocol.AsyncUserProcessor;
import com.alipay.remoting.rpc.protocol.UserProcessor;
import com.alipay.sofa.rpc.codec.bolt.AbstractSerializationRegister;
import com.alipay.sofa.rpc.common.RpcConfigs;
import com.alipay.sofa.rpc.common.SystemInfo;
import com.alipay.sofa.rpc.common.cache.ReflectCache;
import com.alipay.sofa.rpc.common.utils.CommonUtils;
import com.alipay.sofa.rpc.config.ProviderConfig;
import com.alipay.sofa.rpc.config.UserThreadPoolManager;
import com.alipay.sofa.rpc.context.RpcInternalContext;
import com.alipay.sofa.rpc.context.RpcInvokeContext;
import com.alipay.sofa.rpc.context.RpcRuntimeContext;
import com.alipay.sofa.rpc.core.exception.SofaRpcException;
import com.alipay.sofa.rpc.core.request.SofaRequest;
import com.alipay.sofa.rpc.core.response.SofaResponse;
import com.alipay.sofa.rpc.event.EventBus;
import com.alipay.sofa.rpc.event.ServerEndHandleEvent;
import com.alipay.sofa.rpc.event.ServerReceiveEvent;
import com.alipay.sofa.rpc.event.ServerSendEvent;
import com.alipay.sofa.rpc.ext.ExtensionLoaderFactory;
import com.alipay.sofa.rpc.invoke.Invoker;
import com.alipay.sofa.rpc.log.LogCodes;
import com.alipay.sofa.rpc.log.Logger;
import com.alipay.sofa.rpc.log.LoggerFactory;
import com.alipay.sofa.rpc.message.MessageBuilder;
import com.alipay.sofa.rpc.server.ProviderProxyInvoker;
import com.alipay.sofa.rpc.server.UserThreadPool;
import com.alipay.sofa.rpc.server.bolt.BoltServer;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;

public class BoltServerProcessor
extends AsyncUserProcessor<SofaRequest> {
    private static final Logger LOGGER = LoggerFactory.getLogger(BoltServerProcessor.class);
    private final BoltServer boltServer;
    AtomicInteger processingCount = new AtomicInteger(0);

    public BoltServerProcessor(BoltServer boltServer) {
        this.boltServer = boltServer;
        this.executorSelector = new UserThreadPoolSelector();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleRequest(BizContext bizCtx, AsyncContext asyncCtx, SofaRequest request) {
        block26: {
            RpcInternalContext context = RpcInternalContext.getContext();
            context.setProviderSide(true);
            String appName = request.getTargetAppName();
            if (appName == null) {
                appName = (String)RpcRuntimeContext.get("appName");
            }
            boolean isAsyncChain = false;
            try {
                RpcInvokeContext invokeContext;
                this.processingCount.incrementAndGet();
                context.setRemoteAddress(bizCtx.getRemoteHost(), bizCtx.getRemotePort());
                context.setAttachment(".async_context", asyncCtx);
                InvokeContext boltInvokeCtx = bizCtx.getInvokeContext();
                if (RpcInternalContext.isAttachmentEnable() && boltInvokeCtx != null) {
                    this.putToContextIfNotNull(boltInvokeCtx, "bolt.invoke.wait.time", context, "_process_wait_time");
                }
                this.putToContext(boltInvokeCtx);
                if (EventBus.isEnable(ServerReceiveEvent.class)) {
                    EventBus.post(new ServerReceiveEvent(request));
                }
                SofaResponse response = null;
                Exception throwable = null;
                ProviderConfig providerConfig = null;
                String serviceName = request.getTargetServiceUniqueName();
                try {
                    if (!this.boltServer.isStarted()) {
                        throwable = new SofaRpcException(101, LogCodes.getLog("019990009", SystemInfo.getLocalHost() + ":" + this.boltServer.serverConfig.getPort()));
                        response = MessageBuilder.buildSofaErrorResponse(throwable.getMessage());
                    } else if (bizCtx.isRequestTimeout()) {
                        throwable = this.clientTimeoutWhenReceiveRequest(appName, serviceName, bizCtx.getRemoteAddress());
                    } else {
                        Invoker invoker = this.boltServer.findInvoker(serviceName);
                        if (invoker == null) {
                            throwable = this.cannotFoundService(appName, serviceName);
                            response = MessageBuilder.buildSofaErrorResponse(throwable.getMessage());
                        } else {
                            String methodName;
                            Method serviceMethod;
                            if (invoker instanceof ProviderProxyInvoker) {
                                providerConfig = ((ProviderProxyInvoker)invoker).getProviderConfig();
                                String string = appName = providerConfig != null ? providerConfig.getAppName() : null;
                            }
                            if ((serviceMethod = ReflectCache.getOverloadMethodCache(serviceName, methodName = request.getMethodName(), request.getMethodArgSigs())) == null) {
                                throwable = this.cannotFoundServiceMethod(appName, methodName, serviceName);
                                response = MessageBuilder.buildSofaErrorResponse(throwable.getMessage());
                            } else {
                                request.setMethod(serviceMethod);
                                response = this.doInvoke(serviceName, invoker, request);
                                if (bizCtx.isRequestTimeout()) {
                                    throwable = this.clientTimeoutWhenSendResponse(appName, serviceName, bizCtx.getRemoteAddress());
                                }
                            }
                        }
                    }
                }
                catch (Exception e) {
                    LOGGER.errorWithApp(appName, "Server Processor Error!", e);
                    throwable = e;
                    response = MessageBuilder.buildSofaErrorResponse(e.getMessage());
                }
                if (response == null || (isAsyncChain = CommonUtils.isTrue((invokeContext = RpcInvokeContext.peekContext()) != null ? (Boolean)invokeContext.remove("rpc.async.chain") : null))) break block26;
                try {
                    asyncCtx.sendResponse((Object)response);
                }
                finally {
                    if (EventBus.isEnable(ServerSendEvent.class)) {
                        EventBus.post(new ServerSendEvent(request, response, throwable));
                    }
                }
            }
            catch (Throwable e) {
                if (LOGGER.isErrorEnabled(appName)) {
                    LOGGER.errorWithApp(appName, e.getMessage(), e);
                }
            }
            finally {
                this.processingCount.decrementAndGet();
                if (!isAsyncChain && EventBus.isEnable(ServerEndHandleEvent.class)) {
                    EventBus.post(new ServerEndHandleEvent());
                }
                RpcInvokeContext.removeContext();
                RpcInternalContext.removeAllContext();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SofaResponse doInvoke(String serviceName, Invoker invoker, SofaRequest request) throws SofaRpcException {
        ClassLoader rpcCl = Thread.currentThread().getContextClassLoader();
        try {
            ClassLoader serviceCl = ReflectCache.getServiceClassLoader(serviceName);
            Thread.currentThread().setContextClassLoader(serviceCl);
            SofaResponse sofaResponse = invoker.invoke(request);
            return sofaResponse;
        }
        finally {
            Thread.currentThread().setContextClassLoader(rpcCl);
        }
    }

    private void putToContextIfNotNull(InvokeContext invokeContext, String oldKey, RpcInternalContext context, String key) {
        Object value = invokeContext.get(oldKey);
        if (value != null) {
            context.setAttachment(key, value);
        }
    }

    private void putToContext(InvokeContext invokeContext) {
        Long enterQueueTime = (Long)invokeContext.get("bolt.invoke.before.dispatch.in.nano");
        Long processStartTime = (Long)invokeContext.get("bolt.invoke.start.process.in.nano");
        if (enterQueueTime != null && processStartTime != null) {
            RpcInvokeContext.getContext().put("_process_wait_time_nano", processStartTime - enterQueueTime);
        }
        Long headArriveTime = (Long)invokeContext.get("bolt.invoke.request.arrive.header.in.nano");
        Long bodyReceivedTime = (Long)invokeContext.get("bolt.invoke.request.arrive.body.in.nano");
        if (headArriveTime != null && bodyReceivedTime != null) {
            RpcInvokeContext.getContext().put("_server_net_wait_nano", bodyReceivedTime - headArriveTime);
        }
    }

    private SofaRpcException cannotFoundService(String appName, String serviceName) {
        String errorMsg = LogCodes.getLog("020100010", serviceName);
        LOGGER.errorWithApp(appName, errorMsg);
        return new SofaRpcException(110, errorMsg);
    }

    private SofaRpcException cannotFoundServiceMethod(String appName, String serviceName, String methodName) {
        String errorMsg = LogCodes.getLog("020100011", serviceName, methodName);
        LOGGER.errorWithApp(appName, errorMsg);
        return new SofaRpcException(110, errorMsg);
    }

    private SofaRpcException clientTimeoutWhenReceiveRequest(String appName, String serviceName, String remoteAddress) {
        String errorMsg = LogCodes.getLog("020100014", serviceName, remoteAddress);
        if (LOGGER.isWarnEnabled(appName)) {
            LOGGER.warnWithApp(appName, errorMsg);
        }
        return new SofaRpcException(199, errorMsg);
    }

    private SofaRpcException clientTimeoutWhenSendResponse(String appName, String serviceName, String remoteAddress) {
        String errorMsg = LogCodes.getLog("020100015", serviceName, remoteAddress);
        if (LOGGER.isWarnEnabled(appName)) {
            LOGGER.warnWithApp(appName, errorMsg);
        }
        return new SofaRpcException(199, errorMsg);
    }

    public String interest() {
        return SofaRequest.class.getName();
    }

    public Executor getExecutor() {
        return this.boltServer.getBizExecutor();
    }

    public UserProcessor.ExecutorSelector getExecutorSelector() {
        return UserThreadPoolManager.hasUserThread() ? this.executorSelector : null;
    }

    public boolean timeoutDiscard() {
        Map<String, String> parameters = this.boltServer.serverConfig.getParameters();
        if (CommonUtils.isEmpty(parameters)) {
            return false;
        }
        String timeoutDiscard = parameters.get("timeoutDiscard");
        return Boolean.parseBoolean(parameters.get(timeoutDiscard));
    }

    public boolean processInIOThread() {
        Map<String, String> parameters = this.boltServer.serverConfig.getParameters();
        if (CommonUtils.isEmpty(parameters)) {
            return false;
        }
        String processInIOThread = parameters.get("processInIOThread");
        return Boolean.parseBoolean(processInIOThread);
    }

    static {
        String extensionAlias = RpcConfigs.getStringValue("sofa.rpc.bolt.serializer.register.extension");
        ExtensionLoaderFactory.getExtensionLoader(AbstractSerializationRegister.class).getExtension(extensionAlias).doRegisterCustomSerializer();
    }

    public class UserThreadPoolSelector
    implements UserProcessor.ExecutorSelector {
        public Executor select(String requestClass, Object requestHeader) {
            block5: {
                if (SofaRequest.class.getName().equals(requestClass) && requestHeader != null) {
                    Map headerMap = (Map)requestHeader;
                    try {
                        Executor executor;
                        UserThreadPool threadPool;
                        String service = (String)headerMap.get("service");
                        if (service == null) {
                            service = (String)headerMap.get("sofa_head_target_service");
                        }
                        if (service != null && (threadPool = UserThreadPoolManager.getUserThread(service)) != null && (executor = threadPool.getUserExecutor()) != null) {
                            return executor;
                        }
                    }
                    catch (Exception e) {
                        if (!LOGGER.isWarnEnabled()) break block5;
                        LOGGER.warn(LogCodes.getLog("020050001"), e);
                    }
                }
            }
            return BoltServerProcessor.this.getExecutor();
        }
    }
}

