/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.ark.spi.archive;

import com.alipay.sofa.ark.spi.archive.Archive;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class AbstractArchive
implements Archive {
    @Override
    public List<Archive> getNestedArchives(Archive.EntryFilter filter) throws IOException {
        ArrayList<Archive> nestedArchives = new ArrayList<Archive>();
        for (Archive.Entry entry : this) {
            if (!filter.matches(entry)) continue;
            nestedArchives.add(this.getNestedArchive(entry));
        }
        return Collections.unmodifiableList(nestedArchives);
    }

    public URL[] getUrls(Archive.EntryFilter entryFilter) throws IOException {
        List<Archive> archives = this.getNestedArchives(entryFilter);
        ArrayList<URL> urls = new ArrayList<URL>(archives.size());
        urls.add(this.getUrl());
        for (Archive archive : archives) {
            urls.add(archive.getUrl());
        }
        return urls.toArray(new URL[urls.size()]);
    }

    public boolean isEntryExist(Archive.EntryFilter filter) {
        for (Archive.Entry entry : this) {
            if (!filter.matches(entry)) continue;
            return true;
        }
        return false;
    }
}

