/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.runtime.spring.parser;

import com.alipay.sofa.boot.spring.namespace.spi.SofaBootTagNameSupport;
import com.alipay.sofa.runtime.spring.async.AsyncInitBeanHolder;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.BeanDefinitionDecorator;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.context.support.AbstractApplicationContext;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;

public class AsyncInitBeanDefinitionDecorator
implements BeanDefinitionDecorator,
SofaBootTagNameSupport {
    private static final String BEAN_LOAD_COST_FACTORY_CLASS = "com.alipay.sofa.isle.spring.factory.BeanLoadCostBeanFactory";
    private static final String GET_MODULE_NAME_METHOD = "getModuleName";

    public BeanDefinitionHolder decorate(Node node, BeanDefinitionHolder definition, ParserContext parserContext) {
        if (!Boolean.TRUE.toString().equalsIgnoreCase(((Attr)node).getValue())) {
            return definition;
        }
        String moduleName = this.getModuleName(parserContext);
        if (moduleName != null && moduleName.trim().length() > 0) {
            AsyncInitBeanHolder.registerAsyncInitBean(moduleName, definition.getBeanName(), ((AbstractBeanDefinition)definition.getBeanDefinition()).getInitMethodName());
        }
        return definition;
    }

    public String supportTagName() {
        return "async-init";
    }

    private String getModuleName(ParserContext parserContext) {
        ConfigurableListableBeanFactory beanFactory;
        BeanDefinitionRegistry registry = parserContext.getRegistry();
        if (registry instanceof AbstractApplicationContext && AsyncInitBeanDefinitionDecorator.isBeanLoadCostBeanFactory((beanFactory = ((AbstractApplicationContext)registry).getBeanFactory()).getClass())) {
            return AsyncInitBeanDefinitionDecorator.getModuleNameFromBeanFactory(beanFactory);
        }
        if (AsyncInitBeanDefinitionDecorator.isBeanLoadCostBeanFactory(registry.getClass())) {
            return AsyncInitBeanDefinitionDecorator.getModuleNameFromBeanFactory(registry);
        }
        return "RootApplicationContext";
    }

    public static boolean isBeanLoadCostBeanFactory(Class factoryClass) {
        if (factoryClass == null) {
            return false;
        }
        if (BEAN_LOAD_COST_FACTORY_CLASS.equals(factoryClass.getName())) {
            return true;
        }
        if (!Object.class.equals((Object)factoryClass)) {
            return AsyncInitBeanDefinitionDecorator.isBeanLoadCostBeanFactory(factoryClass.getSuperclass());
        }
        return false;
    }

    public static String getModuleNameFromBeanFactory(Object factory) {
        try {
            return (String)factory.getClass().getMethod(GET_MODULE_NAME_METHOD, new Class[0]).invoke(factory, new Object[0]);
        }
        catch (Throwable e) {
            return "RootApplicationContext";
        }
    }
}

