/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.runtime.service.binding;

import com.alipay.sofa.runtime.api.annotation.SofaReference;
import com.alipay.sofa.runtime.api.annotation.SofaReferenceBinding;
import com.alipay.sofa.runtime.api.annotation.SofaService;
import com.alipay.sofa.runtime.api.annotation.SofaServiceBinding;
import com.alipay.sofa.runtime.api.binding.BindingType;
import com.alipay.sofa.runtime.service.binding.JvmBinding;
import com.alipay.sofa.runtime.service.binding.JvmBindingParam;
import com.alipay.sofa.runtime.spi.service.BindingConverter;
import com.alipay.sofa.runtime.spi.service.BindingConverterContext;
import org.w3c.dom.Element;

public class JvmBindingConverter
implements BindingConverter<JvmBindingParam, JvmBinding> {
    @Override
    public JvmBinding convert(JvmBindingParam bindingParam, BindingConverterContext bindingConverterContext) {
        return new JvmBinding().setJvmBindingParam(bindingParam);
    }

    @Override
    public JvmBinding convert(Element element, BindingConverterContext bindingConverterContext) {
        JvmBindingParam jvmBindingParam = new JvmBindingParam();
        if (element != null) {
            jvmBindingParam.setSerialize(Boolean.TRUE.toString().equalsIgnoreCase(element.getAttribute(JvmBinding.XmlConstants.SERIALIZE)));
        }
        return new JvmBinding().setJvmBindingParam(jvmBindingParam);
    }

    @Override
    public JvmBinding convert(SofaService sofaServiceAnnotation, SofaServiceBinding sofaServiceBindingAnnotation, BindingConverterContext bindingConverterContext) {
        if (JvmBinding.XmlConstants.BINDING_TYPE.equals(sofaServiceBindingAnnotation.bindingType())) {
            JvmBindingParam jvmBindingParam = new JvmBindingParam();
            jvmBindingParam.setSerialize(sofaServiceBindingAnnotation.serialize());
            return new JvmBinding().setJvmBindingParam(jvmBindingParam);
        }
        return null;
    }

    @Override
    public JvmBinding convert(SofaReference sofaReferenceAnnotation, SofaReferenceBinding sofaReferenceBindingAnnotation, BindingConverterContext bindingConverterContext) {
        if (JvmBinding.XmlConstants.BINDING_TYPE.equals(sofaReferenceBindingAnnotation.bindingType())) {
            JvmBindingParam jvmBindingParam = new JvmBindingParam();
            jvmBindingParam.setSerialize(sofaReferenceBindingAnnotation.serialize());
            return new JvmBinding().setJvmBindingParam(jvmBindingParam);
        }
        return null;
    }

    @Override
    public BindingType supportBindingType() {
        return JvmBinding.JVM_BINDING_TYPE;
    }

    public String supportTagName() {
        return JvmBinding.XmlConstants.SUPPORT_TAG_NAME;
    }
}

