/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.runtime;

import com.alipay.sofa.runtime.spi.component.SofaRuntimeContext;
import java.util.concurrent.ConcurrentHashMap;

public class SofaRuntimeProperties {
    private static final ConcurrentHashMap<ClassLoader, Boolean> skipJvmReferenceHealthCheckMap = new ConcurrentHashMap();
    private static final ConcurrentHashMap<ClassLoader, Boolean> skipExtensionHealthCheckMap = new ConcurrentHashMap();
    private static final ConcurrentHashMap<ClassLoader, Boolean> disableJvmFirstMap = new ConcurrentHashMap();
    private static final ConcurrentHashMap<ClassLoader, Boolean> skipJvmSerializeMap = new ConcurrentHashMap();
    private static final ConcurrentHashMap<ClassLoader, Boolean> extensionFailureInsulatingMap = new ConcurrentHashMap();
    private static final ConcurrentHashMap<ClassLoader, Boolean> manualReadinessCallbackMap = new ConcurrentHashMap();
    private static boolean jvmFilterEnable = false;

    public static boolean isManualReadinessCallback(ClassLoader classLoader) {
        return manualReadinessCallbackMap.get(classLoader) != null && manualReadinessCallbackMap.get(classLoader) != false;
    }

    public static void setManualReadinessCallback(ClassLoader classLoader, boolean manualReadinessCallback) {
        manualReadinessCallbackMap.putIfAbsent(classLoader, manualReadinessCallback);
    }

    public static boolean isJvmFilterEnable() {
        return jvmFilterEnable;
    }

    public static void setJvmFilterEnable(boolean jvmFilterEnable) {
        SofaRuntimeProperties.jvmFilterEnable = jvmFilterEnable;
    }

    public static boolean isSkipJvmReferenceHealthCheck(SofaRuntimeContext sofaRuntimeContext) {
        return SofaRuntimeProperties.isSkipJvmReferenceHealthCheck(sofaRuntimeContext.getAppClassLoader());
    }

    public static boolean isSkipJvmReferenceHealthCheck(ClassLoader classLoader) {
        return skipJvmReferenceHealthCheckMap.get(classLoader) != null && skipJvmReferenceHealthCheckMap.get(classLoader) != false;
    }

    public static void setSkipJvmReferenceHealthCheck(ClassLoader classLoader, boolean skipJvmReferenceHealthCheck) {
        skipJvmReferenceHealthCheckMap.putIfAbsent(classLoader, skipJvmReferenceHealthCheck);
    }

    public static boolean isExtensionFailureInsulating(ClassLoader classLoader) {
        return extensionFailureInsulatingMap.get(classLoader) != null && extensionFailureInsulatingMap.get(classLoader) != false;
    }

    public static void setExtensionFailureInsulating(ClassLoader classLoader, boolean extensionFailureInsulating) {
        extensionFailureInsulatingMap.putIfAbsent(classLoader, extensionFailureInsulating);
    }

    public static boolean isSkipExtensionHealthCheck(SofaRuntimeContext sofaRuntimeContext) {
        return SofaRuntimeProperties.isSkipExtensionHealthCheck(sofaRuntimeContext.getAppClassLoader());
    }

    public static boolean isSkipExtensionHealthCheck(ClassLoader classLoader) {
        return skipExtensionHealthCheckMap.get(classLoader) != null && skipExtensionHealthCheckMap.get(classLoader) != false;
    }

    public static void setSkipExtensionHealthCheck(ClassLoader classLoader, boolean skipExtensionHealthCheck) {
        skipExtensionHealthCheckMap.putIfAbsent(classLoader, skipExtensionHealthCheck);
    }

    public static boolean isDisableJvmFirst(SofaRuntimeContext sofaRuntimeContext) {
        return SofaRuntimeProperties.isDisableJvmFirst(sofaRuntimeContext.getAppClassLoader());
    }

    public static boolean isDisableJvmFirst(ClassLoader classLoader) {
        return disableJvmFirstMap.get(classLoader) != null && disableJvmFirstMap.get(classLoader) != false;
    }

    public static void setDisableJvmFirst(ClassLoader classLoader, boolean disableJvmFirst) {
        disableJvmFirstMap.putIfAbsent(classLoader, disableJvmFirst);
    }

    public static void unRegisterProperties(ClassLoader classLoader) {
        skipJvmReferenceHealthCheckMap.remove(classLoader);
        disableJvmFirstMap.remove(classLoader);
        skipJvmSerializeMap.remove(classLoader);
    }

    public static Boolean isSkipJvmSerialize(ClassLoader classLoader) {
        return skipJvmSerializeMap.get(classLoader) != null && skipJvmSerializeMap.get(classLoader) != false;
    }

    public static void setSkipJvmSerialize(ClassLoader classLoader, boolean skipJvmSerialize) {
        skipJvmSerializeMap.putIfAbsent(classLoader, skipJvmSerialize);
    }
}

