/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.jraft.processor;

import com.alipay.sofa.registry.jraft.bootstrap.RaftClient;
import com.alipay.sofa.registry.jraft.command.ProcessRequest;
import com.alipay.sofa.registry.jraft.processor.Processor;
import com.alipay.sofa.registry.log.Logger;
import com.alipay.sofa.registry.log.LoggerFactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;

public class ProxyHandler
implements InvocationHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProxyHandler.class);
    private final Class<?> interfaceType;
    private final String serviceId;
    private final RaftClient client;

    public ProxyHandler(Class<?> interfaceType, String serviceId, RaftClient client) {
        this.interfaceType = interfaceType;
        this.serviceId = serviceId;
        this.client = client;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) {
        try {
            ProcessRequest request = new ProcessRequest();
            request.setMethodArgSigs(this.createParamSignature(method.getParameterTypes()));
            request.setMethodName(method.getName());
            request.setMethodArgs(args);
            request.setServiceName(this.serviceId);
            if (Processor.getInstance().isLeaderReadMethod(method)) {
                return this.doInvokeMethod(request);
            }
            return this.client.sendRequest(request);
        }
        catch (Throwable e) {
            LOGGER.error("Proxy invoke interface {} method {} got error!", new Object[]{this.interfaceType.getName(), method.getName(), e});
            throw new RuntimeException(String.format("Proxy invoke interface %s method %s got error!", this.interfaceType.getName(), method.getName()), e);
        }
    }

    private Object doInvokeMethod(ProcessRequest request) {
        try {
            Object target = Processor.getInstance().getWorkers().get(this.serviceId);
            if (target == null) {
                LOGGER.error("Can not find service {} from process!", (Object)this.serviceId);
                throw new RuntimeException(String.format("Can not find service %s from process!", this.serviceId));
            }
            Method method = Processor.getInstance().getWorkMethod(request);
            MethodHandle methodHandle = MethodHandles.lookup().unreflect(method);
            return methodHandle.bindTo(target).invokeWithArguments(request.getMethodArgs());
        }
        catch (Throwable e) {
            LOGGER.error("Directly invoke read only service {} method {} error!", new Object[]{request.getServiceName(), request.getMethodName(), e});
            throw new RuntimeException(String.format("Directly invoke read only service %s method %s error!", request.getServiceName(), request.getMethodName()), e);
        }
    }

    private String[] createParamSignature(Class<?>[] args) {
        if (args == null || args.length == 0) {
            return new String[0];
        }
        String[] paramSig = new String[args.length];
        for (int x = 0; x < args.length; ++x) {
            paramSig[x] = args[x].getName();
        }
        return paramSig;
    }
}

