/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.client.provider;

import com.alipay.sofa.registry.client.api.ConfigDataObserver;
import com.alipay.sofa.registry.client.api.Configurator;
import com.alipay.sofa.registry.client.api.RegistryClientConfig;
import com.alipay.sofa.registry.client.api.model.ConfigData;
import com.alipay.sofa.registry.client.api.registration.ConfiguratorRegistration;
import com.alipay.sofa.registry.client.model.ConfiguratorData;
import com.alipay.sofa.registry.client.provider.AbstractInternalRegister;
import com.alipay.sofa.registry.client.provider.DefaultConfigData;
import com.alipay.sofa.registry.client.task.TaskEvent;
import com.alipay.sofa.registry.client.task.Worker;
import com.alipay.sofa.registry.client.util.StringUtils;
import com.alipay.sofa.registry.core.model.ConfiguratorRegister;
import com.alipay.sofa.registry.core.model.DataBox;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;

public class DefaultConfigurator
extends AbstractInternalRegister
implements Configurator {
    private final String REGIST_ID;
    private ConfiguratorRegistration registration;
    private ConfigDataObserver configDataObserver;
    private RegistryClientConfig config;
    private ConfiguratorData configuratorData;
    private Worker worker;
    private AtomicBoolean init = new AtomicBoolean(false);

    public DefaultConfigurator(ConfiguratorRegistration registration, RegistryClientConfig config, Worker worker) {
        if (null != registration) {
            this.configDataObserver = registration.getConfigDataObserver();
        }
        this.registration = registration;
        this.config = config;
        this.worker = worker;
        this.REGIST_ID = UUID.randomUUID().toString();
    }

    @Override
    public ConfigDataObserver getDataObserver() {
        return this.configDataObserver;
    }

    @Override
    public void setDataObserver(ConfigDataObserver configDataObserver) {
        this.configDataObserver = configDataObserver;
    }

    @Override
    public ConfigData peekData() {
        DataBox dataBox;
        if (!this.init.get()) {
            throw new IllegalStateException("Config data is not ready yet.");
        }
        if (null != this.configuratorData && null != (dataBox = this.configuratorData.getDataBox())) {
            return new DefaultConfigData(dataBox.getData());
        }
        return new DefaultConfigData(null);
    }

    @Override
    public Object assembly() {
        this.readLock.lock();
        ConfiguratorRegister register = new ConfiguratorRegister();
        try {
            register.setInstanceId(this.config.getInstanceId());
            if (StringUtils.isNotEmpty(this.config.getZone())) {
                register.setZone(this.config.getZone());
            } else {
                register.setZone("DEFAULT_ZONE");
            }
            if (StringUtils.isNotEmpty(this.registration.getAppName())) {
                register.setAppName(this.registration.getAppName());
            } else {
                register.setAppName(this.config.getAppName());
            }
            register.setDataId(this.registration.getDataId());
            register.setGroup(this.registration.getGroup());
            register.setRegistId(this.REGIST_ID);
            register.setVersion(this.getPubVersion().get());
            register.setTimestamp(this.getTimestamp());
            this.setAuthSignature(register);
            if (this.isEnabled()) {
                register.setEventType("REGISTER");
            } else {
                register.setEventType("UNREGISTER");
            }
        }
        finally {
            this.readLock.unlock();
        }
        return register;
    }

    public void putConfiguratorData(ConfiguratorData receivedConfigData) {
        this.writeLock.lock();
        try {
            if (null == receivedConfigData) {
                return;
            }
            if (null == receivedConfigData.getVersion()) {
                receivedConfigData.setVersion(0L);
            }
            if (null == this.configuratorData || receivedConfigData.getVersion() > this.configuratorData.getVersion()) {
                this.configuratorData = receivedConfigData;
                this.init.compareAndSet(false, true);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public String getDataId() {
        return this.registration.getDataId();
    }

    @Override
    public String getGroup() {
        return this.registration.getGroup();
    }

    @Override
    public String getRegistId() {
        return this.REGIST_ID;
    }

    @Override
    public void unregister() {
        if (this.isEnabled()) {
            super.unregister();
            this.worker.schedule(new TaskEvent(this));
        }
    }

    @Override
    public String toString() {
        return "DefaultConfigurator{registration=" + this.registration + '}';
    }
}

