/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.lookout.os.linux;

import com.alipay.lookout.api.Gauge;
import com.alipay.lookout.api.Id;
import com.alipay.lookout.api.Registry;
import com.alipay.lookout.api.composite.MixinMetric;
import com.alipay.lookout.common.log.LookoutLoggerFactory;
import com.alipay.lookout.os.CachedMetricsImporter;
import com.alipay.lookout.os.utils.FileUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;

public class NetTrafficMetricsImporter
extends CachedMetricsImporter {
    private final Logger logger = LookoutLoggerFactory.getLogger(NetTrafficMetricsImporter.class);
    private static final String DEFAULT_FILE_PATH = "/proc/net/dev";
    private static final String SPLIT = "\\s+";
    private static final String STR_PATTERN = "\\s+(eth\\d+|em\\d+_\\d+/\\d+|em\\d+_\\d+|em\\d+p\\d+p\\d+_\\d+/\\d+|p\\d+p\\d+_\\d+|p\\d+p\\d+|(?:(?:en|sl|wl|ww)(?:b\\d+|c[0-9a-f]+|o\\d+(?:d\\d+)?|s\\d+(?:f\\d+)?(?:d\\d+)?|x[0-9a-f]+|p\\d+s\\d+(?:f\\d+)?(?:d\\d+)?|p\\d+s\\d+(?:f\\d+)?(?:u\\d+)*(?:c\\d+)?(?:i\\d+)?))):(.*)";
    private static final Pattern NET_PATTERN = Pattern.compile("\\s+(eth\\d+|em\\d+_\\d+/\\d+|em\\d+_\\d+|em\\d+p\\d+p\\d+_\\d+/\\d+|p\\d+p\\d+_\\d+|p\\d+p\\d+|(?:(?:en|sl|wl|ww)(?:b\\d+|c[0-9a-f]+|o\\d+(?:d\\d+)?|s\\d+(?:f\\d+)?(?:d\\d+)?|x[0-9a-f]+|p\\d+s\\d+(?:f\\d+)?(?:d\\d+)?|p\\d+s\\d+(?:f\\d+)?(?:u\\d+)*(?:c\\d+)?(?:i\\d+)?))):(.*)");
    private static final String[] FIELDS = new String[]{"net.in.bytes", "net.in.packets", "net.in.errs", "net.in.dropped", "net.in.fifo.errs", "net.in.frame.errs", "net.in.compressed", "net.in.multicast", "net.out.bytes", "net.out.packets", "net.out.errs", "net.out.dropped", "net.out.fifo.errs", "net.out.collisions", "net.out.carrier.errs", "net.out.compressed"};
    private String filePath;
    private Map<String, Long[]> statByFace;

    public NetTrafficMetricsImporter() {
        this(DEFAULT_FILE_PATH, DEFAULT_TIMEOUT_MS, TimeUnit.MILLISECONDS);
    }

    public NetTrafficMetricsImporter(String filePath, long timeout, TimeUnit timeoutUnit) {
        super(timeout, timeoutUnit);
        this.filePath = filePath;
        this.statByFace = new HashMap<String, Long[]>();
        this.loadIfNessesary();
    }

    public void register(Registry registry) {
        for (Map.Entry<String, Long[]> entry : this.statByFace.entrySet()) {
            final String face = entry.getKey();
            Id id = registry.createId("os.net.stat." + face);
            MixinMetric mixin = registry.mixinMetric(id);
            int i = 0;
            while (i < entry.getValue().length) {
                final int index = i++;
                mixin.gauge(FIELDS[index], (Gauge)new Gauge<Long>(){

                    public Long value() {
                        NetTrafficMetricsImporter.this.loadIfNessesary();
                        return ((Long[])NetTrafficMetricsImporter.this.statByFace.get(face))[index];
                    }
                });
            }
        }
    }

    @Override
    protected void loadValues() {
        try {
            List<String> lines = FileUtils.readFileAsStringArray(this.filePath);
            for (String line : lines) {
                Matcher netMatcher = NET_PATTERN.matcher(line);
                if (!netMatcher.matches()) continue;
                String face = netMatcher.group(1);
                if (this.statByFace.get(face) == null) {
                    this.statByFace.put(face, new Long[FIELDS.length]);
                }
                String[] stats = netMatcher.group(2).trim().split(SPLIT);
                for (int i = 0; i < stats.length; ++i) {
                    this.statByFace.get((Object)face)[i] = Long.parseLong(stats[i]);
                }
            }
        }
        catch (Exception e) {
            this.logger.info("warning,can't parse text at /proc/net/dev", (Object)e.getMessage());
        }
    }
}

