/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.lookout.os.linux;

import com.alipay.lookout.api.Gauge;
import com.alipay.lookout.api.Id;
import com.alipay.lookout.api.Registry;
import com.alipay.lookout.api.composite.MixinMetric;
import com.alipay.lookout.common.log.LookoutLoggerFactory;
import com.alipay.lookout.os.CachedMetricsImporter;
import com.alipay.lookout.os.utils.FileUtils;
import com.alipay.lookout.os.utils.NumFormatUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;

public class IOStatsMetricsImporter
extends CachedMetricsImporter {
    private final Logger logger = LookoutLoggerFactory.getLogger(IOStatsMetricsImporter.class);
    private static final int TOTAL_LENGTH = 14;
    static final int READ_REQUEST_INDEX = 3;
    static final int READ_MERGED_INDEX = 4;
    static final int READ_SECTORS_INDEX = 5;
    static final int MSEC_READ_INDEX = 6;
    static final int WRITE_REQUEST_INDEX = 7;
    static final int WRITE_MERGED_INDEX = 8;
    static final int WRITE_SECTORS_INDEX = 9;
    static final int MSEC_WRITE_INDEX = 10;
    static final int IOS_IN_PROGRESS_INDEX = 11;
    static final int MSEC_TOTAL_INDEX = 12;
    static final int MSEC_WEIGHTED_TOTAL_INDEX = 13;
    private static final String DEFAULT_FILE_PATH = "/proc/diskstats";
    private static final String DEFAULT_UPTIME_FILE_PATH = "/proc/uptime";
    private static final String SPLIT = "\\s+";
    private String filePath;
    private String upTimeFilePath;
    private Map<String, Float[]> statsByDevice;
    private Map<String, DiskInfo> lastDiskInfoMap;
    private float lastUpTime;

    public IOStatsMetricsImporter() {
        this(DEFAULT_FILE_PATH, DEFAULT_UPTIME_FILE_PATH, DEFAULT_TIMEOUT_MS, TimeUnit.MILLISECONDS);
    }

    public IOStatsMetricsImporter(String filePath, String upTimeFilePath, long timeout, TimeUnit timeoutUnit) {
        super(timeout, timeoutUnit);
        this.filePath = filePath;
        this.upTimeFilePath = upTimeFilePath;
        this.statsByDevice = new HashMap<String, Float[]>();
        this.lastDiskInfoMap = new HashMap<String, DiskInfo>();
        this.loadIfNessesary();
    }

    public void register(Registry registry) {
        for (Map.Entry<String, Float[]> entry : this.statsByDevice.entrySet()) {
            final String device = entry.getKey();
            Id id = registry.createId("os.io.stats." + device);
            id = id.withTag("device", device);
            MixinMetric mixin = registry.mixinMetric(id);
            mixin.gauge("svctm", (Gauge)new Gauge<Float>(){

                public Float value() {
                    IOStatsMetricsImporter.this.loadIfNessesary();
                    return ((Float[])IOStatsMetricsImporter.this.statsByDevice.get(device))[IOStats.SVCTM.ordinal()];
                }
            });
            mixin.gauge("r_await", (Gauge)new Gauge<Float>(){

                public Float value() {
                    IOStatsMetricsImporter.this.loadIfNessesary();
                    return ((Float[])IOStatsMetricsImporter.this.statsByDevice.get(device))[IOStats.R_AWAIT.ordinal()];
                }
            });
            mixin.gauge("w_await", (Gauge)new Gauge<Float>(){

                public Float value() {
                    IOStatsMetricsImporter.this.loadIfNessesary();
                    return ((Float[])IOStatsMetricsImporter.this.statsByDevice.get(device))[IOStats.W_AWAIT.ordinal()];
                }
            });
            mixin.gauge("await", (Gauge)new Gauge<Float>(){

                public Float value() {
                    IOStatsMetricsImporter.this.loadIfNessesary();
                    return ((Float[])IOStatsMetricsImporter.this.statsByDevice.get(device))[IOStats.AWAIT.ordinal()];
                }
            });
            mixin.gauge("util", (Gauge)new Gauge<Float>(){

                public Float value() {
                    IOStatsMetricsImporter.this.loadIfNessesary();
                    return ((Float[])IOStatsMetricsImporter.this.statsByDevice.get(device))[IOStats.UTIL.ordinal()];
                }
            });
        }
    }

    @Override
    protected void loadValues() {
        float deltaTime = this.collectUpTime();
        if (deltaTime == 0.0f) {
            this.logger.info("warning,calculate delta time failed!");
            return;
        }
        Map<String, DiskInfo> diskInfoMap = this.collectDiskInfo();
        for (Map.Entry<String, DiskInfo> entry : diskInfoMap.entrySet()) {
            String device = entry.getKey();
            if (this.statsByDevice.get(device) == null) {
                this.statsByDevice.put(device, new Float[IOStats.values().length]);
            }
            this.calDiskUsage(deltaTime, device, entry.getValue(), this.statsByDevice.get(device));
        }
        this.lastDiskInfoMap = diskInfoMap;
    }

    private float collectUpTime() {
        try {
            String line = FileUtils.readFile(this.upTimeFilePath);
            float currentUpTime = Float.parseFloat(line.split(SPLIT)[0]);
            float deltaTime = currentUpTime - this.lastUpTime;
            this.lastUpTime = currentUpTime;
            return deltaTime;
        }
        catch (Exception e) {
            this.logger.info("warning,can't parse line at /proc/uptime", (Object)e.getMessage());
            return 0.0f;
        }
    }

    private Map<String, DiskInfo> collectDiskInfo() {
        HashMap<String, DiskInfo> results = new HashMap<String, DiskInfo>();
        try {
            List<String> lines = FileUtils.readFileAsStringArray(this.filePath);
            for (String line : lines) {
                String[] stats = line.trim().split(SPLIT);
                if (stats == null || stats.length != 14) {
                    this.logger.info("warning,can't parse text at /proc/diskstats, line: " + line);
                    continue;
                }
                if (Long.parseLong(stats[DiskStats.STATS.ordinal()]) == 0L || !this.isDevice(stats)) continue;
                String device = stats[DiskStats.DEVICE.ordinal()];
                DiskInfo diskInfo = new DiskInfo();
                block16: for (int index = DiskStats.STATS.ordinal(); index < stats.length; ++index) {
                    long stat = Long.parseLong(stats[index]);
                    switch (index) {
                        case 3: {
                            diskInfo.readRequests = stat;
                            continue block16;
                        }
                        case 4: {
                            diskInfo.readMerged = stat;
                            continue block16;
                        }
                        case 5: {
                            diskInfo.readSectors = stat;
                            continue block16;
                        }
                        case 6: {
                            diskInfo.msecRead = stat;
                            continue block16;
                        }
                        case 7: {
                            diskInfo.writRequests = stat;
                            continue block16;
                        }
                        case 8: {
                            diskInfo.writeMerged = stat;
                            continue block16;
                        }
                        case 9: {
                            diskInfo.writeSectors = stat;
                            continue block16;
                        }
                        case 10: {
                            diskInfo.msecWrite = stat;
                            continue block16;
                        }
                        case 11: {
                            diskInfo.iosInProgress = stat;
                            continue block16;
                        }
                        case 12: {
                            diskInfo.msecTotal = stat;
                            continue block16;
                        }
                        case 13: {
                            diskInfo.msecWeightedTotal = stat;
                        }
                    }
                }
                results.put(device, diskInfo);
            }
        }
        catch (Exception e) {
            this.logger.info("warning,can't parse text at /proc/diskstats", (Object)e.getMessage());
        }
        return results;
    }

    private boolean isDevice(String[] stats) {
        return Long.parseLong(stats[DiskStats.MIN.ordinal()]) % 16L == 0L && Long.parseLong(stats[DiskStats.MAJ.ordinal()]) > 0L;
    }

    private void calDiskUsage(float deltaTime, String device, DiskInfo diskInfo, Float[] stats) {
        DiskInfo lastDiskInfo = this.lastDiskInfoMap.get(device);
        if (lastDiskInfo == null) {
            stats[IOStats.UTIL.ordinal()] = Float.valueOf(0.0f);
            stats[IOStats.SVCTM.ordinal()] = Float.valueOf(0.0f);
            stats[IOStats.R_AWAIT.ordinal()] = Float.valueOf(0.0f);
            stats[IOStats.W_AWAIT.ordinal()] = Float.valueOf(0.0f);
            stats[IOStats.AWAIT.ordinal()] = Float.valueOf(0.0f);
            return;
        }
        long totalRequests = diskInfo.readRequests + diskInfo.writRequests;
        long lastTotalRequests = lastDiskInfo.readRequests + lastDiskInfo.writRequests;
        long totalTicks = diskInfo.msecRead + diskInfo.msecWrite;
        long lastTotalTicks = lastDiskInfo.msecRead + lastDiskInfo.msecWrite;
        float util = 100.0f * (float)(diskInfo.msecTotal - lastDiskInfo.msecTotal) / deltaTime;
        float tPut = NumFormatUtils.formatFloat(100.0f * (float)(totalRequests - lastTotalRequests) / deltaTime);
        stats[IOStats.SVCTM.ordinal()] = tPut > 0.0f ? Float.valueOf(NumFormatUtils.formatFloat(util / tPut)) : Float.valueOf(0.0f);
        stats[IOStats.R_AWAIT.ordinal()] = diskInfo.readRequests != lastDiskInfo.readRequests ? Float.valueOf(NumFormatUtils.formatFloat((float)(diskInfo.msecRead - lastDiskInfo.msecRead) / (float)(diskInfo.readRequests - lastDiskInfo.readRequests))) : Float.valueOf(0.0f);
        if (diskInfo.writRequests != lastDiskInfo.writRequests) {
            stats[IOStats.W_AWAIT.ordinal()] = Float.valueOf(NumFormatUtils.formatFloat((float)(diskInfo.msecWrite - lastDiskInfo.msecWrite) / (float)(diskInfo.writRequests - lastDiskInfo.writRequests)));
        }
        if (totalRequests != lastTotalRequests) {
            stats[IOStats.AWAIT.ordinal()] = Float.valueOf(NumFormatUtils.formatFloat((float)(totalTicks - lastTotalTicks) / (float)(totalRequests - lastTotalRequests)));
        }
        stats[IOStats.UTIL.ordinal()] = Float.valueOf(NumFormatUtils.formatFloat(util / 1000.0f));
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public void setUpTimeFilePath(String upTimeFilePath) {
        this.upTimeFilePath = upTimeFilePath;
    }

    private class DiskInfo {
        private long readRequests;
        private long readMerged;
        private long readSectors;
        private long msecRead;
        private long writRequests;
        private long writeMerged;
        private long writeSectors;
        private long msecWrite;
        private long iosInProgress;
        private long msecTotal;
        private long msecWeightedTotal;

        private DiskInfo() {
        }
    }

    private static enum DiskStats {
        MAJ,
        MIN,
        DEVICE,
        STATS;

    }

    private static enum IOStats {
        SVCTM,
        R_AWAIT,
        W_AWAIT,
        AWAIT,
        UTIL;

    }
}

