/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.remoting;

import com.alipay.remoting.ConnectionMonitorStrategy;
import com.alipay.remoting.ConnectionPool;
import com.alipay.remoting.DefaultConnectionManager;
import com.alipay.remoting.NamedThreadFactory;
import com.alipay.remoting.SystemProperties;
import com.alipay.remoting.log.BoltLoggerFactory;
import com.alipay.remoting.util.RunStateRecordedFutureTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;

public class DefaultConnectionMonitor {
    private static final Logger logger = BoltLoggerFactory.getLogger("CommonDefault");
    private DefaultConnectionManager connectionManager;
    private ConnectionMonitorStrategy strategy;
    private ScheduledThreadPoolExecutor executor;

    public DefaultConnectionMonitor(ConnectionMonitorStrategy strategy, DefaultConnectionManager connectionManager) {
        this.strategy = strategy;
        this.connectionManager = connectionManager;
    }

    public void start() {
        long initialDelay = SystemProperties.conn_monitor_initial_delay();
        long period = SystemProperties.conn_monitor_period();
        this.executor = new ScheduledThreadPoolExecutor(1, new NamedThreadFactory("ConnectionMonitorThread"), new ThreadPoolExecutor.AbortPolicy());
        MonitorTask monitorTask = new MonitorTask();
        this.executor.scheduleAtFixedRate(monitorTask, initialDelay, period, TimeUnit.MILLISECONDS);
    }

    public void destroy() {
        this.executor.purge();
        this.executor.shutdown();
    }

    private class MonitorTask
    implements Runnable {
        private MonitorTask() {
        }

        @Override
        public void run() {
            try {
                if (DefaultConnectionMonitor.this.strategy != null) {
                    ConcurrentHashMap<String, RunStateRecordedFutureTask<ConnectionPool>> connPools = DefaultConnectionMonitor.this.connectionManager.getConnPools();
                    DefaultConnectionMonitor.this.strategy.monitor(connPools);
                }
            }
            catch (Exception e) {
                logger.warn("MonitorTask error", (Throwable)e);
            }
        }
    }
}

