package com.alipay.api.response;

import java.util.List;
import com.alipay.api.internal.mapping.ApiField;
import com.alipay.api.internal.mapping.ApiListField;
import com.alipay.api.domain.SearchBoxAccountModule;
import com.alipay.api.domain.SearchBoxAreaKeyWordModule;
import com.alipay.api.domain.SearchBoxBasicInfoModule;
import com.alipay.api.domain.BoxBusinessDistrictModule;
import com.alipay.api.domain.SearchBoxKeyWordModule;
import com.alipay.api.domain.SearchBoxImageModule;
import com.alipay.api.domain.SearchBoxServiceModule;

import com.alipay.api.AlipayResponse;

/**
 * ALIPAY API: alipay.open.search.box.query response.
 * 
 * @author auto create
 * @since 1.0, 2023-07-07 10:51:57
 */
public class AlipayOpenSearchBoxQueryResponse extends AlipayResponse {

	private static final long serialVersionUID = 1624455751538959258L;

	/** 
	 * 搜索直达账号模块
	 */
	@ApiField("account_module")
	private SearchBoxAccountModule accountModule;

	/** 
	 * 地域触发词
	 */
	@ApiField("area_keyword_module")
	private SearchBoxAreaKeyWordModule areaKeywordModule;

	/** 
	 * 搜索直达基础信息模块
	 */
	@ApiField("basic_info_module")
	private SearchBoxBasicInfoModule basicInfoModule;

	/** 
	 * 搜索直达配置id
	 */
	@ApiField("box_id")
	private String boxId;

	/** 
	 * 搜索直达配置状态，AUDIT-审核中/ONLINE-已上架/REJECT-驳回/OFFLINE-已下架
	 */
	@ApiField("box_status")
	private String boxStatus;

	/** 
	 * 商圈信息
	 */
	@ApiField("business_district_module")
	private BoxBusinessDistrictModule businessDistrictModule;

	/** 
	 * 搜索直达默认触发词，由系统生成，无法修改
	 */
	@ApiListField("default_keywords")
	@ApiField("string")
	private List<String> defaultKeywords;

	/** 
	 * 搜索直达关键词模块
	 */
	@ApiField("keyword_module")
	private SearchBoxKeyWordModule keywordModule;

	/** 
	 * 最近一次审核氛围图
	 */
	@ApiField("latest_audit_image")
	private SearchBoxImageModule latestAuditImage;

	/** 
	 * 搜索直达服务模块
	 */
	@ApiField("service_module")
	private SearchBoxServiceModule serviceModule;

	/** 
	 * 已生效氛围图
	 */
	@ApiField("valid_image")
	private SearchBoxImageModule validImage;

	public void setAccountModule(SearchBoxAccountModule accountModule) {
		this.accountModule = accountModule;
	}
	public SearchBoxAccountModule getAccountModule( ) {
		return this.accountModule;
	}

	public void setAreaKeywordModule(SearchBoxAreaKeyWordModule areaKeywordModule) {
		this.areaKeywordModule = areaKeywordModule;
	}
	public SearchBoxAreaKeyWordModule getAreaKeywordModule( ) {
		return this.areaKeywordModule;
	}

	public void setBasicInfoModule(SearchBoxBasicInfoModule basicInfoModule) {
		this.basicInfoModule = basicInfoModule;
	}
	public SearchBoxBasicInfoModule getBasicInfoModule( ) {
		return this.basicInfoModule;
	}

	public void setBoxId(String boxId) {
		this.boxId = boxId;
	}
	public String getBoxId( ) {
		return this.boxId;
	}

	public void setBoxStatus(String boxStatus) {
		this.boxStatus = boxStatus;
	}
	public String getBoxStatus( ) {
		return this.boxStatus;
	}

	public void setBusinessDistrictModule(BoxBusinessDistrictModule businessDistrictModule) {
		this.businessDistrictModule = businessDistrictModule;
	}
	public BoxBusinessDistrictModule getBusinessDistrictModule( ) {
		return this.businessDistrictModule;
	}

	public void setDefaultKeywords(List<String> defaultKeywords) {
		this.defaultKeywords = defaultKeywords;
	}
	public List<String> getDefaultKeywords( ) {
		return this.defaultKeywords;
	}

	public void setKeywordModule(SearchBoxKeyWordModule keywordModule) {
		this.keywordModule = keywordModule;
	}
	public SearchBoxKeyWordModule getKeywordModule( ) {
		return this.keywordModule;
	}

	public void setLatestAuditImage(SearchBoxImageModule latestAuditImage) {
		this.latestAuditImage = latestAuditImage;
	}
	public SearchBoxImageModule getLatestAuditImage( ) {
		return this.latestAuditImage;
	}

	public void setServiceModule(SearchBoxServiceModule serviceModule) {
		this.serviceModule = serviceModule;
	}
	public SearchBoxServiceModule getServiceModule( ) {
		return this.serviceModule;
	}

	public void setValidImage(SearchBoxImageModule validImage) {
		this.validImage = validImage;
	}
	public SearchBoxImageModule getValidImage( ) {
		return this.validImage;
	}

}
