/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.node.etl.transform.transformer;

import com.alibaba.otter.node.etl.common.db.dialect.DbDialect;
import com.alibaba.otter.node.etl.common.db.dialect.DbDialectFactory;
import com.alibaba.otter.node.etl.common.db.utils.DdlUtils;
import com.alibaba.otter.node.etl.transform.exception.TransformException;
import com.alibaba.otter.node.etl.transform.transformer.AbstractOtterTransformer;
import com.alibaba.otter.node.etl.transform.transformer.OtterTransformerContext;
import com.alibaba.otter.shared.common.model.config.ConfigHelper;
import com.alibaba.otter.shared.common.model.config.data.ColumnPair;
import com.alibaba.otter.shared.common.model.config.data.DataMedia;
import com.alibaba.otter.shared.common.model.config.data.DataMediaPair;
import com.alibaba.otter.shared.common.model.config.data.db.DbMediaSource;
import com.alibaba.otter.shared.etl.model.EventColumn;
import com.alibaba.otter.shared.etl.model.EventData;
import com.alibaba.otter.shared.etl.model.EventType;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.ddlutils.model.Column;
import org.apache.ddlutils.model.Table;
import org.springframework.util.CollectionUtils;

public class RowDataTransformer
extends AbstractOtterTransformer<EventData, EventData> {
    private DbDialectFactory dbDialectFactory;

    @Override
    public EventData transform(EventData data, OtterTransformerContext context) {
        EventData result = new EventData();
        DataMedia dataMedia = context.getDataMediaPair().getTarget();
        result.setPairId(context.getDataMediaPair().getId().longValue());
        result.setTableId(dataMedia.getId().longValue());
        this.buildName(data, result, context.getDataMediaPair());
        result.setEventType(data.getEventType());
        result.setExecuteTime(data.getExecuteTime());
        result.setSyncConsistency(data.getSyncConsistency());
        result.setRemedy(data.isRemedy());
        result.setSyncMode(data.getSyncMode());
        result.setSize(data.getSize());
        result.setHint(data.getHint());
        result.setWithoutSchema(data.isWithoutSchema());
        if (data.getEventType().isDdl()) {
            if (StringUtils.equalsIgnoreCase((String)result.getSchemaName(), (String)data.getSchemaName()) && StringUtils.equalsIgnoreCase((String)result.getTableName(), (String)data.getTableName())) {
                result.setDdlSchemaName(data.getDdlSchemaName());
                result.setSql(data.getSql());
                return result;
            }
            String sql = DdlUtils.convert(data.getSql(), data.getSchemaName(), data.getTableName(), result.getSchemaName(), result.getTableName());
            result.setDdlSchemaName(result.getSchemaName());
            result.setSql(sql);
            return result;
        }
        HashMultimap translateColumnNames = HashMultimap.create();
        if (context.getDataMediaPair().getColumnPairMode().isInclude()) {
            List columnPairs = context.getDataMediaPair().getColumnPairs();
            for (ColumnPair columnPair : columnPairs) {
                translateColumnNames.put((Object)columnPair.getSourceColumn().getName(), (Object)columnPair.getTargetColumn().getName());
            }
        }
        DataMediaPair dataMediaPair = context.getDataMediaPair();
        boolean useTableTransform = context.getPipeline().getParameters().getUseTableTransform();
        boolean enableCompatibleMissColumn = context.getPipeline().getParameters().getEnableCompatibleMissColumn();
        TableInfoHolder tableHolder = null;
        if (useTableTransform || enableCompatibleMissColumn) {
            DbDialect dbDialect = this.dbDialectFactory.getDbDialect(dataMediaPair.getPipelineId(), (DbMediaSource)dataMedia.getSource());
            Table table = dbDialect.findTable(result.getSchemaName(), result.getTableName());
            tableHolder = new TableInfoHolder(table, useTableTransform, enableCompatibleMissColumn);
        }
        List<EventColumn> otherColumns = this.translateColumns(result, data.getColumns(), context.getDataMediaPair(), (Multimap<String, String>)translateColumnNames, tableHolder);
        this.translatePkColumn(result, data.getKeys(), data.getOldKeys(), otherColumns, context.getDataMediaPair(), (Multimap<String, String>)translateColumnNames, tableHolder);
        result.setColumns(otherColumns);
        return result;
    }

    private void buildName(EventData data, EventData result, DataMediaPair pair) {
        DataMedia targetDataMedia = pair.getTarget();
        DataMedia sourceDataMedia = pair.getSource();
        String schemaName = this.buildName(data.getSchemaName(), sourceDataMedia.getNamespaceMode(), targetDataMedia.getNamespaceMode());
        String tableName = this.buildName(data.getTableName(), sourceDataMedia.getNameMode(), targetDataMedia.getNameMode());
        result.setSchemaName(schemaName);
        result.setTableName(tableName);
    }

    private String buildName(String name, DataMedia.ModeValue sourceModeValue, DataMedia.ModeValue targetModeValue) {
        if (targetModeValue.getMode().isWildCard()) {
            return name;
        }
        if (targetModeValue.getMode().isMulti()) {
            int index = ConfigHelper.indexIgnoreCase((List)sourceModeValue.getMultiValue(), (String)name);
            if (index == -1) {
                throw new TransformException("can not found namespace or name in media:" + sourceModeValue.toString());
            }
            return (String)targetModeValue.getMultiValue().get(index);
        }
        return targetModeValue.getSingleValue();
    }

    private List<EventColumn> translateColumns(EventData data, List<EventColumn> columns, DataMediaPair dataMediaPair, Multimap<String, String> translateColumnNames, TableInfoHolder tableHolder) {
        ArrayList<EventColumn> tcolumns = new ArrayList<EventColumn>();
        for (EventColumn scolumn : columns) {
            EventColumn tcolumn = this.translateColumn(data, scolumn, tableHolder, dataMediaPair, translateColumnNames);
            if (tcolumn == null) continue;
            tcolumns.add(tcolumn);
        }
        return tcolumns;
    }

    private void translatePkColumn(EventData data, List<EventColumn> pks, List<EventColumn> oldPks, List<EventColumn> columns, DataMediaPair dataMediaPair, Multimap<String, String> translateColumnNames, TableInfoHolder tableHolder) {
        if (CollectionUtils.isEmpty(oldPks)) {
            ArrayList<EventColumn> tpks = new ArrayList<EventColumn>();
            for (EventColumn scolumn : pks) {
                EventColumn tcolumn = this.translateColumn(data, scolumn, tableHolder, dataMediaPair, translateColumnNames);
                if (tcolumn == null) continue;
                tpks.add(tcolumn);
            }
            data.setKeys(tpks);
        } else {
            ArrayList<EventColumn> tnewPks = new ArrayList<EventColumn>();
            ArrayList<EventColumn> toldPks = new ArrayList<EventColumn>();
            for (int i = 0; i < pks.size(); ++i) {
                EventColumn newPk = pks.get(i);
                EventColumn oldPk = oldPks.get(i);
                EventColumn tnewPk = this.translateColumn(data, newPk, tableHolder, dataMediaPair, translateColumnNames);
                if (tnewPk == null) continue;
                tnewPks.add(tnewPk);
                EventColumn transEventColumn = this.translateColumn(tnewPk, oldPk.getColumnValue(), dataMediaPair);
                transEventColumn.setUpdate(oldPk.isUpdate());
                toldPks.add(transEventColumn);
            }
            data.setKeys(tnewPks);
            data.setOldKeys(toldPks);
        }
    }

    private EventColumn translateColumn(EventData data, EventColumn scolumn, TableInfoHolder tableHolder, DataMediaPair dataMediaPair, Multimap<String, String> translateColumnNames) {
        EventType type = data.getEventType();
        EventColumn tcolumn = new EventColumn();
        tcolumn.setNull(scolumn.getColumnValue() == null);
        tcolumn.setKey(scolumn.isKey());
        tcolumn.setIndex(scolumn.getIndex());
        tcolumn.setUpdate(scolumn.isUpdate());
        String columnName = this.translateColumnName(scolumn.getColumnName(), dataMediaPair, translateColumnNames);
        if (StringUtils.isBlank((String)columnName)) {
            throw new TransformException("can't translate column name:" + scolumn.getColumnName() + "in pair:" + dataMediaPair.toString());
        }
        tcolumn.setColumnName(columnName);
        tcolumn.setColumnType(scolumn.getColumnType());
        if (tableHolder != null) {
            boolean canColumnsNotExist = tableHolder.isEnableCompatibleMissColumn();
            if (type == EventType.UPDATE) {
                canColumnsNotExist &= !scolumn.isUpdate() && scolumn.isNull();
            } else if (type == EventType.INSERT) {
                canColumnsNotExist &= scolumn.isNull();
            } else if (type == EventType.DELETE) {
                canColumnsNotExist &= !scolumn.isKey();
            }
            Column matchDbColumn = this.getMatchColumn(tableHolder.getTable().getColumns(), tcolumn.getColumnName());
            if (matchDbColumn == null) {
                DbMediaSource dbMediaSource = (DbMediaSource)dataMediaPair.getTarget().getSource();
                DbDialect dbDialect = this.dbDialectFactory.getDbDialect(dataMediaPair.getPipelineId(), dbMediaSource);
                String schemaName = tableHolder.getTable().getSchema();
                if (StringUtils.isEmpty((String)schemaName)) {
                    schemaName = tableHolder.getTable().getCatalog();
                }
                Table table = dbDialect.findTable(schemaName, tableHolder.getTable().getName(), false);
                tableHolder.setTable(table);
                matchDbColumn = this.getMatchColumn(tableHolder.getTable().getColumns(), tcolumn.getColumnName());
                if (matchDbColumn == null) {
                    if (canColumnsNotExist) {
                        return null;
                    }
                    throw new TransformException(scolumn.getColumnName() + " is not found in " + table.toString() + " and source : " + dataMediaPair.getTarget().getNamespace() + "." + dataMediaPair.getTarget().getName());
                }
            }
            if (tableHolder.isUseTableTransform()) {
                int sqlType = matchDbColumn.getTypeCode();
                tcolumn.setColumnType(sqlType);
            }
        }
        tcolumn.setColumnValue(scolumn.getColumnValue());
        translateColumnNames.remove((Object)scolumn.getColumnName(), (Object)columnName);
        return tcolumn;
    }

    private EventColumn translateColumn(EventColumn scolumn, String newValue, DataMediaPair dataMediaPair) {
        EventColumn tcolumn = new EventColumn();
        tcolumn.setNull(newValue == null);
        tcolumn.setKey(scolumn.isKey());
        tcolumn.setIndex(scolumn.getIndex());
        tcolumn.setColumnName(scolumn.getColumnName());
        tcolumn.setColumnType(scolumn.getColumnType());
        tcolumn.setUpdate(scolumn.isUpdate());
        tcolumn.setColumnValue(newValue);
        return tcolumn;
    }

    private String translateColumnName(String srcColumnName, DataMediaPair dataMediaPair, Multimap<String, String> translateDict) {
        if (dataMediaPair.getColumnPairMode().isExclude() || CollectionUtils.isEmpty((Collection)dataMediaPair.getColumnPairs())) {
            return srcColumnName;
        }
        Collection tColumnNames = translateDict.get((Object)srcColumnName);
        if (CollectionUtils.isEmpty((Collection)tColumnNames)) {
            throw new TransformException(srcColumnName + " is not found in column pairs: " + translateDict.toString());
        }
        String columnName = (String)tColumnNames.iterator().next();
        return columnName;
    }

    private Column getMatchColumn(Column[] columns, String columnName) {
        for (Column column : columns) {
            if (!column.getName().equalsIgnoreCase(columnName)) continue;
            return column;
        }
        return null;
    }

    public void setDbDialectFactory(DbDialectFactory dbDialectFactory) {
        this.dbDialectFactory = dbDialectFactory;
    }

    static class TableInfoHolder {
        private Table table;
        private boolean useTableTransform = true;
        private boolean enableCompatibleMissColumn = true;

        public TableInfoHolder(Table table, boolean useTableTransform, boolean enableCompatibleMissColumn) {
            this.useTableTransform = useTableTransform;
            this.enableCompatibleMissColumn = enableCompatibleMissColumn;
            this.table = table;
        }

        public Table getTable() {
            return this.table;
        }

        public void setTable(Table table) {
            this.table = table;
        }

        public boolean isUseTableTransform() {
            return this.useTableTransform;
        }

        public void setUseTableTransform(boolean useTableTransform) {
            this.useTableTransform = useTableTransform;
        }

        public boolean isEnableCompatibleMissColumn() {
            return this.enableCompatibleMissColumn;
        }

        public void setEnableCompatibleMissColumn(boolean enableCompatibleMissColumn) {
            this.enableCompatibleMissColumn = enableCompatibleMissColumn;
        }
    }
}

