/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.node.etl.transform.transformer;

import com.alibaba.otter.node.common.config.ConfigClientService;
import com.alibaba.otter.node.etl.transform.exception.TransformException;
import com.alibaba.otter.node.etl.transform.transformer.FileDataTransformer;
import com.alibaba.otter.node.etl.transform.transformer.OtterTransformer;
import com.alibaba.otter.node.etl.transform.transformer.OtterTransformerContext;
import com.alibaba.otter.node.etl.transform.transformer.RowDataTransformer;
import com.alibaba.otter.shared.common.model.config.ConfigHelper;
import com.alibaba.otter.shared.common.model.config.data.DataMedia;
import com.alibaba.otter.shared.common.model.config.data.DataMediaPair;
import com.alibaba.otter.shared.common.model.config.data.db.DbDataMedia;
import com.alibaba.otter.shared.common.model.config.pipeline.Pipeline;
import com.alibaba.otter.shared.etl.model.BatchObject;
import com.alibaba.otter.shared.etl.model.EventData;
import com.alibaba.otter.shared.etl.model.FileBatch;
import com.alibaba.otter.shared.etl.model.FileData;
import com.alibaba.otter.shared.etl.model.Identity;
import com.alibaba.otter.shared.etl.model.RowBatch;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OtterTransformerFactory {
    private ConfigClientService configClientService;
    private RowDataTransformer rowDataTransformer;
    private FileDataTransformer fileDataTransformer;

    public Map<Class, BatchObject> transform(RowBatch rowBatch) {
        Identity identity = this.translateIdentity(rowBatch.getIdentity());
        HashMap<Class, BatchObject> result = new HashMap<Class, BatchObject>();
        result.put(EventData.class, this.initBatchObject(identity, EventData.class));
        for (EventData eventData : rowBatch.getDatas()) {
            Long tableId = eventData.getTableId();
            Pipeline pipeline = this.configClientService.findPipeline(Long.valueOf(identity.getPipelineId()));
            List dataMediaPairs = ConfigHelper.findDataMediaPairByMediaId((Pipeline)pipeline, (Long)tableId);
            for (DataMediaPair pair : dataMediaPairs) {
                OtterTransformer translate;
                Object item;
                if (!pair.getSource().getId().equals(tableId) || (item = (translate = this.lookup(pair.getSource(), pair.getTarget())).transform(eventData, new OtterTransformerContext(identity, pair, pipeline))) == null) continue;
                this.merge(identity, result, item);
            }
        }
        return result;
    }

    public Map<Class, BatchObject> transform(FileBatch fileBatch) {
        Identity identity = this.translateIdentity(fileBatch.getIdentity());
        List fileDatas = fileBatch.getFiles();
        HashMap<Class, BatchObject> result = new HashMap<Class, BatchObject>();
        result.put(FileData.class, this.initBatchObject(identity, FileData.class));
        for (FileData fileData : fileDatas) {
            Long tableId = fileData.getTableId();
            Pipeline pipeline = this.configClientService.findPipeline(Long.valueOf(identity.getPipelineId()));
            List dataMediaPairs = ConfigHelper.findDataMediaPairByMediaId((Pipeline)pipeline, (Long)tableId);
            for (DataMediaPair pair : dataMediaPairs) {
                FileData item;
                if (!pair.getSource().getId().equals(tableId) || (item = this.fileDataTransformer.transform(fileData, new OtterTransformerContext(identity, pair, pipeline))) == null) continue;
                this.merge(identity, result, item);
            }
        }
        return result;
    }

    private synchronized void merge(Identity identity, Map<Class, BatchObject> data, Object item) {
        Class<?> clazz = item.getClass();
        BatchObject batchObject = data.get(clazz);
        if (batchObject == null) {
            batchObject = this.initBatchObject(identity, clazz);
            data.put(clazz, batchObject);
        }
        if (batchObject instanceof RowBatch) {
            ((RowBatch)batchObject).merge((EventData)item);
        } else if (batchObject instanceof FileBatch) {
            ((FileBatch)batchObject).getFiles().add((FileData)item);
        } else {
            throw new TransformException("no support Data[" + clazz.getName() + "]");
        }
    }

    private BatchObject initBatchObject(Identity identity, Class clazz) {
        if (EventData.class.equals((Object)clazz)) {
            RowBatch rowbatch = new RowBatch();
            rowbatch.setIdentity(identity);
            return rowbatch;
        }
        if (FileData.class.equals((Object)clazz)) {
            FileBatch fileBatch = new FileBatch();
            fileBatch.setIdentity(identity);
            return fileBatch;
        }
        throw new TransformException("no support Data[" + clazz.getName() + "]");
    }

    private OtterTransformer lookup(DataMedia sourceDataMedia, DataMedia targetDataMedia) {
        if (sourceDataMedia instanceof DbDataMedia && targetDataMedia instanceof DbDataMedia) {
            return this.rowDataTransformer;
        }
        throw new TransformException("no support translate for source " + sourceDataMedia.toString() + " to target " + targetDataMedia);
    }

    private Identity translateIdentity(Identity identity) {
        Identity result = new Identity();
        result.setChannelId(identity.getChannelId());
        result.setPipelineId(identity.getPipelineId());
        result.setProcessId(identity.getProcessId());
        return result;
    }

    public void setConfigClientService(ConfigClientService configClientService) {
        this.configClientService = configClientService;
    }

    public void setRowDataTransformer(RowDataTransformer rowDataTransformer) {
        this.rowDataTransformer = rowDataTransformer;
    }

    public void setFileDataTransformer(FileDataTransformer fileDataTransformer) {
        this.fileDataTransformer = fileDataTransformer;
    }
}

