/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.node.etl.transform;

import com.alibaba.otter.node.etl.common.jmx.StageAggregation;
import com.alibaba.otter.node.etl.common.pipe.PipeKey;
import com.alibaba.otter.node.etl.common.task.GlobalTask;
import com.alibaba.otter.node.etl.extract.SetlFuture;
import com.alibaba.otter.node.etl.transform.transformer.OtterTransformerFactory;
import com.alibaba.otter.shared.arbitrate.model.EtlEventData;
import com.alibaba.otter.shared.common.model.config.enums.StageType;
import com.alibaba.otter.shared.etl.model.BatchObject;
import com.alibaba.otter.shared.etl.model.DbBatch;
import com.alibaba.otter.shared.etl.model.EventData;
import com.alibaba.otter.shared.etl.model.FileBatch;
import com.alibaba.otter.shared.etl.model.FileData;
import com.alibaba.otter.shared.etl.model.RowBatch;
import java.util.List;
import java.util.Map;
import org.slf4j.MDC;

public class TransformTask
extends GlobalTask {
    private OtterTransformerFactory otterTransformerFactory;

    public TransformTask(Long pipelineId) {
        super(pipelineId);
    }

    @Override
    public void run() {
        MDC.put((String)"otter", (String)String.valueOf(this.pipelineId));
        while (this.running) {
            try {
                final EtlEventData etlEventData = this.arbitrateEventService.transformEvent().await(this.pipelineId);
                Runnable task = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        boolean profiling = TransformTask.this.isProfiling();
                        Long profilingStartTime = null;
                        if (profiling) {
                            profilingStartTime = System.currentTimeMillis();
                        }
                        MDC.put((String)"otter", (String)String.valueOf(TransformTask.this.pipelineId));
                        String currentName = Thread.currentThread().getName();
                        Thread.currentThread().setName(TransformTask.this.createTaskName(TransformTask.this.pipelineId, "transformWorker"));
                        try {
                            List keys = (List)etlEventData.getDesc();
                            DbBatch dbBatch = TransformTask.this.rowDataPipeDelegate.get(keys);
                            if (dbBatch == null) {
                                TransformTask.this.processMissData(TransformTask.this.pipelineId, "transform miss data with keys:" + keys.toString());
                                return;
                            }
                            Map<Class, BatchObject> dataBatchs = TransformTask.this.otterTransformerFactory.transform(dbBatch.getRowBatch());
                            dbBatch.setRowBatch((RowBatch)dataBatchs.get(EventData.class));
                            if (dbBatch.getFileBatch() != null) {
                                Map<Class, BatchObject> fileBatchs = TransformTask.this.otterTransformerFactory.transform(dbBatch.getFileBatch());
                                dbBatch.setFileBatch((FileBatch)fileBatchs.get(FileData.class));
                            }
                            List<PipeKey> nextKeys = TransformTask.this.rowDataPipeDelegate.put(dbBatch, etlEventData.getNextNid());
                            etlEventData.setDesc(nextKeys);
                            if (profiling) {
                                Long profilingEndTime = System.currentTimeMillis();
                                TransformTask.this.stageAggregationCollector.push(TransformTask.this.pipelineId, StageType.TRANSFORM, new StageAggregation.AggregationItem(profilingStartTime, profilingEndTime));
                            }
                            TransformTask.this.arbitrateEventService.transformEvent().single(etlEventData);
                        }
                        catch (Throwable e) {
                            if (!TransformTask.this.isInterrupt(e)) {
                                TransformTask.this.logger.error(String.format("[%s] transformWork executor is error! data:%s", TransformTask.this.pipelineId, etlEventData), e);
                                TransformTask.this.sendRollbackTermin(TransformTask.this.pipelineId, e);
                            } else {
                                TransformTask.this.logger.info(String.format("[%s] transformWork executor is interrrupt! data:%s", TransformTask.this.pipelineId, etlEventData), e);
                            }
                        }
                        finally {
                            Thread.currentThread().setName(currentName);
                            MDC.remove((String)"otter");
                        }
                    }
                };
                SetlFuture extractFuture = new SetlFuture(StageType.TRANSFORM, etlEventData.getProcessId(), this.pendingFuture, task);
                this.executorService.execute(extractFuture);
            }
            catch (Throwable e) {
                if (this.isInterrupt(e)) {
                    this.logger.info(String.format("[%s] transformTask is interrupted!", this.pipelineId), e);
                    return;
                }
                this.logger.error(String.format("[%s] transformTask is error!", this.pipelineId), e);
                this.sendRollbackTermin((long)this.pipelineId, e);
            }
        }
    }

    public void setOtterTransformerFactory(OtterTransformerFactory otterTransformerFactory) {
        this.otterTransformerFactory = otterTransformerFactory;
    }
}

